/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services.utils;

import java.sql.SQLException;
import java.util.Calendar;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.resource.beans.ContentDownloadBean;
import org.wso2.carbon.registry.resource.services.utils.InputStreamBasedDataSource;
import org.wso2.carbon.registry.resource.services.utils.ResourceContentInputStream;

public class GetDownloadContentUtil {
    private static final Log log = LogFactory.getLog(GetDownloadContentUtil.class);

    public static ContentDownloadBean getContentDownloadBean(String path, UserRegistry userRegistry) throws RegistryException {
        try {
            ContentDownloadBean bean = new ContentDownloadBean();
            Resource resource = userRegistry.get(path);
            if (resource instanceof Collection) {
                String msg = "Could not get the resource content. Path " + path + " refers to a collection.";
                log.error((Object)msg);
                throw new RegistryException(msg);
            }
            bean.setMediatype(resource.getMediaType());
            Calendar lastModified = Calendar.getInstance();
            lastModified.setTime(resource.getLastModified());
            bean.setLastUpdatedTime(lastModified);
            bean.setResourceName(RegistryUtils.getResourceName((String)path));
            if (resource.getContent() != null) {
                InputStreamBasedDataSource contentSource = new InputStreamBasedDataSource(new ResourceContentInputStream(resource));
                DataHandler content = new DataHandler((DataSource)contentSource);
                bean.setContent(content);
            } else {
                bean.setContent(null);
            }
            return bean;
        }
        catch (RegistryException e) {
            String msg = "Failed to get content of the resource for downloading. " + (e.getCause() instanceof SQLException ? "" : e.getMessage());
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }
}

