/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services.utils;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.common.utils.UserUtil;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.RemoteConfiguration;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.secure.AuthorizationFailedException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.resource.beans.CollectionContentBean;
import org.wso2.carbon.registry.resource.beans.ContentBean;

public class ContentUtil {
    private static final Log log = LogFactory.getLog(ContentUtil.class);

    public static CollectionContentBean getCollectionContent(String path, UserRegistry registry) throws Exception {
        try {
            Resource resource = registry.get(path);
            if (!(resource instanceof Collection)) {
                String msg = "Attempted to get collection content from a non-collection resource " + path;
                log.error((Object)msg);
                throw new RegistryException(msg);
            }
            Collection collection = (Collection)resource;
            String[] childPaths = collection.getChildren();
            CollectionContentBean bean = new CollectionContentBean();
            bean.setChildPaths(childPaths);
            bean.setChildCount(childPaths.length);
            bean.setCollectionTypes(ContentUtil.getCollectionTypes());
            if (registry.getRegistryContext() != null) {
                List remoteInstances = registry.getRegistryContext().getRemoteInstances();
                String[] instances = new String[remoteInstances.size()];
                for (int i = 0; i < instances.length; ++i) {
                    instances[i] = ((RemoteConfiguration)remoteInstances.get(i)).getId();
                }
                bean.setRemoteInstances(instances);
            }
            ResourcePath resourcePath = new ResourcePath(path);
            bean.setPathWithVersion(resourcePath.getPathWithVersion());
            bean.setVersionView(!resourcePath.isCurrentVersion());
            return bean;
        }
        catch (Exception e) {
            String msg = "Failed to get content details of the resource " + path + ". Caused by: " + (e.getCause() instanceof SQLException ? "" : e.getMessage());
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public static ResourceData[] getResourceData(String[] childPaths, UserRegistry registry) throws Exception {
        ArrayList<ResourceData> resourceDataList = new ArrayList<ResourceData>();
        for (String childPath : childPaths) {
            try {
                if (childPath == null || childPath.length() == 0) continue;
                Resource child = registry.get(childPath);
                ResourceData resourceData = new ResourceData();
                resourceData.setResourcePath(childPath);
                String[] parts = childPath.split("/");
                if (parts.length > 0) {
                    resourceData.setName(parts[parts.length - 1]);
                }
                resourceData.setResourceType(child instanceof Collection ? "collection" : "resource");
                resourceData.setAuthorUserName(child.getAuthorUserName());
                resourceData.setDescription(child.getDescription());
                resourceData.setAverageRating(registry.getAverageRating(child.getPath()));
                Calendar createDateTime = Calendar.getInstance();
                createDateTime.setTime(child.getCreatedTime());
                resourceData.setCreatedOn(createDateTime);
                List mountPoints = child.getPropertyValues("registry.mountpoint");
                List targetPoints = child.getPropertyValues("registry.targetpoint");
                List actualPaths = child.getPropertyValues("registry.actualpath");
                String user = child.getProperty("registry.user");
                if (child.getProperty("registry.mount") != null) {
                    resourceData.setMounted(true);
                }
                if (child.getProperty("registry.link") != null) {
                    resourceData.setLink(true);
                    if (mountPoints != null && targetPoints != null) {
                        String tempPath = (String)actualPaths.get(0);
                        resourceData.setPutAllowed(UserUtil.isPutAllowed((String)registry.getUserName(), (String)tempPath, (UserRegistry)registry));
                        resourceData.setDeleteAllowed(UserUtil.isDeleteAllowed((String)registry.getUserName(), (String)tempPath, (UserRegistry)registry));
                        resourceData.setGetAllowed(UserUtil.isGetAllowed((String)registry.getUserName(), (String)tempPath, (UserRegistry)registry));
                        resourceData.setRealPath(tempPath);
                    } else if (user != null) {
                        if (registry.getUserName().equals(user)) {
                            resourceData.setPutAllowed(true);
                            resourceData.setDeleteAllowed(true);
                            resourceData.setGetAllowed(true);
                        } else {
                            resourceData.setPutAllowed(UserUtil.isPutAllowed((String)registry.getUserName(), (String)childPath, (UserRegistry)registry));
                            resourceData.setDeleteAllowed(UserUtil.isDeleteAllowed((String)registry.getUserName(), (String)childPath, (UserRegistry)registry));
                            resourceData.setGetAllowed(UserUtil.isGetAllowed((String)registry.getUserName(), (String)childPath, (UserRegistry)registry));
                        }
                    }
                } else {
                    resourceData.setPutAllowed(UserUtil.isPutAllowed((String)registry.getUserName(), (String)childPath, (UserRegistry)registry));
                    resourceData.setDeleteAllowed(UserUtil.isDeleteAllowed((String)registry.getUserName(), (String)childPath, (UserRegistry)registry));
                    resourceData.setGetAllowed(UserUtil.isGetAllowed((String)registry.getUserName(), (String)childPath, (UserRegistry)registry));
                }
                ContentUtil.calculateAverageStars(resourceData);
                if (child.getProperty("registry.externalLink") != null) {
                    resourceData.setExternalLink(true);
                }
                if (child.getProperty("registry.absent") != null) {
                    resourceData.setAbsent(child.getProperty("registry.absent"));
                }
                resourceDataList.add(resourceData);
            }
            catch (AuthorizationFailedException ignore) {
                // empty catch block
            }
        }
        return resourceDataList.toArray(new ResourceData[resourceDataList.size()]);
    }

    public static ContentBean getContent(String path, UserRegistry registry) throws Exception {
        ResourcePath resourcePath = new ResourcePath(path);
        ContentBean bean = new ContentBean();
        Resource resource = registry.get(path);
        bean.setMediaType(resource.getMediaType());
        bean.setCollection(resource instanceof Collection);
        bean.setLoggedIn(!"wso2.anonymous.user".equals(registry.getUserName()));
        bean.setPathWithVersion(resourcePath.getPathWithVersion());
        bean.setAbsent(resource.getProperty("registry.absent"));
        List mountPoints = resource.getPropertyValues("registry.mountpoint");
        List targetPoints = resource.getPropertyValues("registry.targetpoint");
        List actualPaths = resource.getPropertyValues("registry.actualpath");
        String user = resource.getProperty("registry.user");
        if (resource.getProperty("registry.link") != null) {
            if (mountPoints != null && targetPoints != null) {
                String tempPath = (String)actualPaths.get(0);
                bean.setPutAllowed(UserUtil.isPutAllowed((String)registry.getUserName(), (String)tempPath, (UserRegistry)registry));
                bean.setRealPath(tempPath);
            } else if (user != null) {
                if (registry.getUserName().equals(user)) {
                    bean.setPutAllowed(true);
                } else {
                    bean.setPutAllowed(UserUtil.isPutAllowed((String)registry.getUserName(), (String)path, (UserRegistry)registry));
                }
            }
        } else {
            boolean putAllowed = UserUtil.isPutAllowed((String)registry.getUserName(), (String)path, (UserRegistry)registry);
            bean.setPutAllowed(putAllowed);
        }
        bean.setVersionView(!resourcePath.isCurrentVersion());
        bean.setContentPath(resourcePath.getCompletePath());
        resource.discard();
        return bean;
    }

    private static String[] getCollectionTypes() {
        return new String[]{"default", "Axis2 repository", "Synapse repository"};
    }

    private static void calculateAverageStars(ResourceData resourceData) {
        float tempRating = resourceData.getAverageRating() * 1000.0f;
        tempRating = Math.round(tempRating);
        resourceData.setAverageRating(tempRating /= 1000.0f);
        float averageRating = resourceData.getAverageRating();
        String[] averageStars = new String[5];
        for (int i = 0; i < 5; ++i) {
            float fraction;
            averageStars[i] = averageRating >= (float)(i + 1) ? "04" : (averageRating <= (float)i ? "00" : ((double)(fraction = averageRating - (float)i) <= 0.125 ? "00" : ((double)fraction > 0.125 && (double)fraction <= 0.375 ? "01" : ((double)fraction > 0.375 && (double)fraction <= 0.625 ? "02" : ((double)fraction > 0.625 && (double)fraction <= 0.875 ? "03" : "04")))));
        }
        resourceData.setAverageStars(averageStars);
    }
}

