/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.common.eventing.NotificationService;
import org.wso2.carbon.registry.common.eventing.RegistryEvent;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;

public class CommonUtil {
    private static final Log log = LogFactory.getLog(CommonUtil.class);
    private static RegistryService registryService;
    private static NotificationService registryNotificationService;

    public static synchronized void setRegistryService(RegistryService service) {
        registryService = service;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static void setRegistryNotificationService(NotificationService registryNotificationService) {
        CommonUtil.registryNotificationService = registryNotificationService;
    }

    public static void notify(RegistryEvent event, Registry registry, String path) throws Exception {
        try {
            if (registryNotificationService == null) {
                log.debug((Object)"Eventing service is unavailable.");
                return;
            }
            if (registry == null || registry.getEventingServiceURL(path) == null) {
                registryNotificationService.notify(event);
            } else if (registry.getEventingServiceURL(null) == null) {
                log.error((Object)"Unable to send notification.");
            } else if (registry.getEventingServiceURL(path).equals(registry.getEventingServiceURL(null))) {
                registryNotificationService.notify(event);
            } else {
                registryNotificationService.notify(event, registry.getEventingServiceURL(path));
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to send notification", (Throwable)e);
        }
    }
}

