/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.common.eventing.RegistryEvent;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.resource.services.utils.CommonUtil;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

public class ChangeRolePermissionsUtil {
    private static final Log log = LogFactory.getLog(ChangeRolePermissionsUtil.class);

    public static void changeRolePermissions(UserRegistry userRegistry, String resourcePath, String permissionString) throws Exception {
        AuthorizationManager accessControlAdmin;
        UserRealm realm;
        try {
            realm = userRegistry.getUserRealm();
            accessControlAdmin = realm.getAuthorizationManager();
        }
        catch (Exception e) {
            String msg = "Couldn't get access control admin for changing authorizations. Caused by: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        try {
            String[] rolePermissions = permissionString.split("\\|");
            for (int i = 0; i < rolePermissions.length; ++i) {
                boolean isResource;
                RealmConfiguration realmConfig;
                String notificationResponse = "The following changes have been made.";
                if (rolePermissions[i].trim().length() == 0) continue;
                String[] permissions = rolePermissions[i].split(":");
                String permRole = permissions[0];
                if (!permRole.equals((realmConfig = realm.getRealmConfiguration()).getAdminRoleName())) {
                    accessControlAdmin.clearRoleAuthorization(permRole, resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                    accessControlAdmin.clearRoleAuthorization(permRole, resourcePath, "http://www.wso2.org/projects/registry/actions/add");
                    accessControlAdmin.clearRoleAuthorization(permRole, resourcePath, "http://www.wso2.org/projects/registry/actions/delete");
                    accessControlAdmin.clearRoleAuthorization(permRole, resourcePath, "authorize");
                }
                for (int j = 1; j < permissions.length; ++j) {
                    String[] permission = permissions[j].split("\\^");
                    String action = permission[0];
                    String checked = permission[1];
                    if (action.equals("ra")) {
                        if (!checked.equals("true")) continue;
                        accessControlAdmin.authorizeRole(permRole, resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                        notificationResponse = notificationResponse + " READ: Allowed.";
                        continue;
                    }
                    if (action.equals("rd")) {
                        if (!checked.equals("true")) continue;
                        accessControlAdmin.denyRole(permRole, resourcePath, "http://www.wso2.org/projects/registry/actions/get");
                        notificationResponse = notificationResponse + " READ: Denied.";
                        continue;
                    }
                    if (action.equals("wa")) {
                        if (!checked.equals("true")) continue;
                        accessControlAdmin.authorizeRole(permRole, resourcePath, "http://www.wso2.org/projects/registry/actions/add");
                        notificationResponse = notificationResponse + " WRITE: Allowed.";
                        continue;
                    }
                    if (action.equals("wd")) {
                        if (!checked.equals("true")) continue;
                        accessControlAdmin.denyRole(permRole, resourcePath, "http://www.wso2.org/projects/registry/actions/add");
                        notificationResponse = notificationResponse + " WRITE: Denied.";
                        continue;
                    }
                    if (action.equals("da")) {
                        if (!checked.equals("true")) continue;
                        accessControlAdmin.authorizeRole(permRole, resourcePath, "http://www.wso2.org/projects/registry/actions/delete");
                        notificationResponse = notificationResponse + " DELETE: Allowed.";
                        continue;
                    }
                    if (action.equals("dd")) {
                        if (!checked.equals("true")) continue;
                        accessControlAdmin.denyRole(permRole, resourcePath, "http://www.wso2.org/projects/registry/actions/delete");
                        notificationResponse = notificationResponse + " DELETE: Denied.";
                        continue;
                    }
                    if (action.equals("aa")) {
                        if (!checked.equals("true")) continue;
                        accessControlAdmin.authorizeRole(permRole, resourcePath, "authorize");
                        notificationResponse = notificationResponse + " AUTHORIZE: Allowed.";
                        continue;
                    }
                    if (!action.equals("ad") || !checked.equals("true")) continue;
                    accessControlAdmin.denyRole(permRole, resourcePath, "authorize");
                    notificationResponse = notificationResponse + " AUTHORIZE: Denied.";
                }
                String message = "The permissions have been changed for the role " + permRole + " on resource " + resourcePath + ". " + notificationResponse;
                try {
                    isResource = !(userRegistry.get(resourcePath) instanceof Collection);
                }
                catch (RegistryException e) {
                    isResource = true;
                }
                RegistryEvent event = new RegistryEvent((Object)message);
                if (isResource) {
                    event.setTopic("/ResourceUpdated" + resourcePath);
                } else {
                    event.setTopic("/CollectionUpdated" + resourcePath);
                }
                event.setTenantId(userRegistry.getTenantId());
                CommonUtil.notify(event, (Registry)userRegistry, resourcePath);
            }
            String msg = "Role authorizations performed successfully.";
            log.debug((Object)msg);
        }
        catch (UserStoreException e) {
            String msg = "Couldn't set authorizations. Caused by: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }
}

