/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.services.utils;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class AddTextResourceUtil {
    private static final Log log = LogFactory.getLog(AddTextResourceUtil.class);

    public static void addTextResource(String parentPath, String resourceName, String mediaType, String description, String contentString, UserRegistry userRegistry) throws Exception {
        String resourcePath = "/".equals(parentPath) ? "/" + resourceName : parentPath + "/" + resourceName;
        byte[] content = null;
        if (contentString != null) {
            content = RegistryUtils.encodeString((String)contentString);
        }
        try {
            Resource resource = userRegistry.newResource();
            resource.setMediaType(mediaType);
            resource.setDescription(description);
            resource.setContent((Object)RegistryUtils.decodeBytes((byte[])content));
            userRegistry.put(resourcePath, resource);
            resource.discard();
        }
        catch (RegistryException e) {
            String msg = "Failed to add resource with text based content to path " + resourcePath + ". " + (e.getCause() instanceof SQLException ? "" : e.getMessage());
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }
}

