/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.ui.processors;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.common.ui.UIException;
import org.wso2.carbon.registry.resource.ui.clients.ResourceServiceClient;

public class MoveProcessor {
    private static final Log log = LogFactory.getLog(MoveProcessor.class);

    public static void process(HttpServletRequest request, HttpServletResponse response, ServletConfig config) throws UIException {
        String parentPath = request.getParameter("parentPath");
        String oldResourcePath = request.getParameter("oldResourcePath");
        String destinationPath = request.getParameter("destinationPath");
        String resourceName = request.getParameter("resourceName");
        String cookie = (String)request.getSession().getAttribute("wso2carbon.admin.service.cookie");
        try {
            ResourceServiceClient client = new ResourceServiceClient(cookie, config, request.getSession());
            client.moveResource(parentPath, oldResourcePath, destinationPath, resourceName);
        }
        catch (Exception e) {
            String msg = "Failed to move resource " + oldResourcePath + " to the path " + destinationPath + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new UIException((Throwable)e);
        }
    }
}

