/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.ui.processors;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.common.ui.UIException;
import org.wso2.carbon.registry.core.utils.MediaTypesUtils;
import org.wso2.carbon.registry.resource.ui.clients.ResourceServiceClient;
import org.wso2.carbon.server.admin.common.IServerAdmin;
import org.wso2.carbon.server.admin.common.ServerData;
import org.wso2.carbon.server.admin.ui.ServerAdminClient;
import org.wso2.carbon.ui.CarbonUIUtil;

public class ImportResourceProcessor {
    private static final Log log = LogFactory.getLog(ImportResourceProcessor.class);

    public static void process(HttpServletRequest request, HttpServletResponse response, ServletConfig config) throws UIException {
        String parentPath = request.getParameter("parentPath");
        String resourceName = request.getParameter("resourceName");
        String mediaType = MediaTypesUtils.getMimeTypeFromHumanReadableMediaType((String)request.getParameter("mediaType"));
        String description = request.getParameter("description");
        String fetchURL = request.getParameter("fetchURL");
        String isAsync = request.getParameter("isAsync");
        String symlinkLocation = request.getParameter("symlinkLocation");
        String cookie = (String)request.getSession().getAttribute("wso2carbon.admin.service.cookie");
        HttpSession session = request.getSession();
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        try {
            ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
            IServerAdmin adminClient = (IServerAdmin)CarbonUIUtil.getServerProxy((Object)new ServerAdminClient(configContext, serverURL, cookie, session), IServerAdmin.class, (HttpSession)session);
            ServerData data = null;
            String chroot = "";
            try {
                data = adminClient.getServerData();
            }
            catch (Exception ignored) {
                chroot = null;
            }
            if (data != null && data.getRegistryType() != null && data.getRegistryType().equals("remote") && data.getRemoteRegistryChroot() != null && !data.getRemoteRegistryChroot().equals("/")) {
                chroot = data.getRemoteRegistryChroot();
                if (!chroot.startsWith("/")) {
                    chroot = "/" + chroot;
                }
                if (chroot.endsWith("/")) {
                    chroot = chroot.substring(0, chroot.length() - "/".length());
                }
            }
            if (chroot == null) {
                symlinkLocation = null;
                log.debug((Object)"Unable to determine chroot. Symbolic Link cannot be created");
            }
            if (symlinkLocation != null) {
                symlinkLocation = chroot + symlinkLocation;
            }
            ResourceServiceClient client = new ResourceServiceClient(cookie, config, request.getSession());
            if (JavaUtils.isTrueExplicitly((String)isAsync)) {
                client.importResource(parentPath, resourceName, mediaType, description, fetchURL, symlinkLocation, true);
            } else {
                client.importResource(parentPath, resourceName, mediaType, description, fetchURL, symlinkLocation, false);
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new UIException(msg, (Throwable)e);
        }
    }
}

