/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.ui.processors;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import javax.activation.DataHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.registry.core.utils.MediaTypesUtils;
import org.wso2.carbon.registry.resource.ui.clients.ResourceServiceClient;
import org.wso2.carbon.server.admin.common.IServerAdmin;
import org.wso2.carbon.server.admin.common.ServerData;
import org.wso2.carbon.server.admin.ui.ServerAdminClient;
import org.wso2.carbon.ui.CarbonUIMessage;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.ui.transports.fileupload.FileSizeLimitExceededException;
import org.wso2.carbon.ui.transports.fileupload.FileUploadFailedException;
import org.wso2.carbon.utils.FileItemData;

public class AddResourceProcessor
extends AbstractFileUploadExecutor {
    private static final Log log = LogFactory.getLog(AddResourceProcessor.class);

    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        String webContext = (String)request.getAttribute("WebContext");
        String serverURL = (String)request.getAttribute("ServerURL");
        String cookie = (String)request.getAttribute("wso2carbon.admin.service.cookie");
        HttpSession session = request.getSession();
        Map fileItemsMap = this.getFileItemsMap();
        Map formFieldsMap = this.getFormFieldsMap();
        if (fileItemsMap == null || fileItemsMap.isEmpty()) {
            String msg = "File upload failed. Content is not set properly.";
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request);
            response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/resources/resource.jsp?region=region3&item=resource_browser_menu&errorMsg=" + msg);
            return false;
        }
        String errorRedirect = null;
        try {
            Object errorAttribute;
            if (formFieldsMap.get("errorRedirect") != null) {
                errorRedirect = (String)((ArrayList)formFieldsMap.get("errorRedirect")).get(0);
            }
            if (session != null && (errorAttribute = session.getAttribute("fileSizeExceededError")) != null) {
                session.removeAttribute("fileSizeExceededError");
                String msg = "File upload failed. " + errorAttribute;
                if (errorRedirect == null) {
                    CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request);
                    response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/resources/resource.jsp?region=region3&item=resource_browser_menu&errorMsg=" + msg);
                } else {
                    response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/" + errorRedirect + (errorRedirect.indexOf("?") == -1 ? "?" : "&") + "msg=" + URLEncoder.encode(msg, "UTF-8"));
                }
                return false;
            }
            ResourceServiceClient client = new ResourceServiceClient(cookie, serverURL, this.configurationContext);
            String parentPath = null;
            if (formFieldsMap.get("path") != null) {
                parentPath = (String)((ArrayList)formFieldsMap.get("path")).get(0);
            }
            String resourceName = null;
            if (formFieldsMap.get("filename") != null) {
                resourceName = (String)((ArrayList)formFieldsMap.get("filename")).get(0);
            }
            String mediaType = null;
            if (formFieldsMap.get("mediaType") != null) {
                mediaType = MediaTypesUtils.getMimeTypeFromHumanReadableMediaType((String)((String)((ArrayList)formFieldsMap.get("mediaType")).get(0)));
            }
            String description = null;
            if (formFieldsMap.get("description") != null) {
                description = (String)((ArrayList)formFieldsMap.get("description")).get(0);
            }
            String redirect = null;
            if (formFieldsMap.get("redirect") != null) {
                redirect = (String)((ArrayList)formFieldsMap.get("redirect")).get(0);
            }
            String symlinkLocation = null;
            if (formFieldsMap.get("symlinkLocation") != null) {
                symlinkLocation = (String)((ArrayList)formFieldsMap.get("symlinkLocation")).get(0);
            }
            IServerAdmin adminClient = (IServerAdmin)CarbonUIUtil.getServerProxy((Object)new ServerAdminClient(this.configurationContext, serverURL, cookie, session), IServerAdmin.class, (HttpSession)session);
            ServerData data = null;
            String chroot = "";
            try {
                data = adminClient.getServerData();
            }
            catch (Exception ignored) {
                chroot = null;
            }
            if (data != null && data.getRegistryType() != null && data.getRegistryType().equals("remote") && data.getRemoteRegistryChroot() != null && !data.getRemoteRegistryChroot().equals("/")) {
                chroot = data.getRemoteRegistryChroot();
                if (!chroot.startsWith("/")) {
                    chroot = "/" + chroot;
                }
                if (chroot.endsWith("/")) {
                    chroot = chroot.substring(0, chroot.length() - "/".length());
                }
            }
            if (chroot == null) {
                symlinkLocation = null;
                log.debug((Object)"Unable to determine chroot. Symbolic Link cannot be created");
            }
            if (symlinkLocation != null) {
                symlinkLocation = chroot + symlinkLocation;
            }
            FileItemData fileItemData = (FileItemData)((ArrayList)fileItemsMap.get("upload")).get(0);
            DataHandler dataHandler = fileItemData.getDataHandler();
            if (parentPath == null || resourceName == null) {
                String msg = "File upload failed. The parent path and resource name must be provided.";
                log.error((Object)msg);
                this.buildUIError(request, response, webContext, errorRedirect, msg);
                return false;
            }
            client.addResource(AddResourceProcessor.calculatePath(parentPath, resourceName), mediaType, description, dataHandler, symlinkLocation);
            response.setContentType("text/html; charset=utf-8");
            String msg = "Successfully uploaded content.";
            if (redirect == null) {
                CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"info", (HttpServletRequest)request);
                parentPath = "/".equals(parentPath) ? parentPath + "&viewType=std" : URLEncoder.encode(parentPath, "UTF-8");
                response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/resources/resource.jsp?region=region3&item=resource_browser_menu&path=" + parentPath);
            } else {
                response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/" + redirect);
            }
            return true;
        }
        catch (IOException e) {
            String msg = "File upload failed. " + e.getMessage();
            log.error((Object)"File upload failed. ", (Throwable)e);
            if (errorRedirect == null) {
                CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request);
                response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/resources/resource.jsp?region=region3&item=resource_browser_menu&errorMsg=" + msg);
            } else {
                response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/" + errorRedirect + (errorRedirect.indexOf("?") == -1 ? "?" : "&") + "msg=" + URLEncoder.encode(msg, "UTF-8"));
            }
            return false;
        }
        catch (RuntimeException e) {
            String msg = "File upload failed. " + e.getMessage();
            log.error((Object)"File upload failed. ", (Throwable)e);
            this.buildUIError(request, response, webContext, errorRedirect, msg);
            return false;
        }
        catch (Exception e) {
            String msg = "File upload failed. " + e.getMessage();
            log.error((Object)"File upload failed. ", (Throwable)e);
            this.buildUIError(request, response, webContext, errorRedirect, msg);
            return false;
        }
    }

    protected void parseRequest(HttpServletRequest request) throws FileUploadFailedException, FileSizeLimitExceededException {
        try {
            super.parseRequest(request);
        }
        catch (FileSizeLimitExceededException e) {
            request.getSession().setAttribute("fileSizeExceededError", (Object)e.getMessage());
            log.error((Object)"You have exceeded the allowed maximum file upload size", (Throwable)e);
        }
    }

    private void buildUIError(HttpServletRequest request, HttpServletResponse response, String webContext, String errorRedirect, String msg) throws IOException {
        CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request);
        if (errorRedirect == null) {
            response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/resources/resource.jsp?region=region3&item=resource_browser_menu&errorMsg=" + msg);
        } else {
            response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/" + errorRedirect + (errorRedirect.indexOf("?") == -1 ? "?" : "&") + "msg=" + URLEncoder.encode(msg, "UTF-8"));
        }
    }

    private static String calculatePath(String parentPath, String resourceName) {
        if (!parentPath.startsWith("/")) {
            parentPath = "/" + parentPath;
        }
        String resourcePath = parentPath.endsWith("/") ? parentPath + resourceName : parentPath + "/" + resourceName;
        return resourcePath;
    }
}

