/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.ui.processors;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.common.ui.UIException;
import org.wso2.carbon.registry.core.utils.MediaTypesUtils;
import org.wso2.carbon.registry.resource.ui.clients.ResourceServiceClient;

public class AddCollectionProcessor {
    private static final Log log = LogFactory.getLog(AddCollectionProcessor.class);

    public static String process(HttpServletRequest request, HttpServletResponse response, ServletConfig config) throws UIException {
        String parentPath = request.getParameter("parentPath");
        String collectionName = request.getParameter("collectionName");
        String mediaType = MediaTypesUtils.getMimeTypeFromHumanReadableMediaType((String)request.getParameter("mediaType"));
        String description = request.getParameter("description");
        String cookie = (String)request.getSession().getAttribute("wso2carbon.admin.service.cookie");
        try {
            ResourceServiceClient client = new ResourceServiceClient(cookie, config, request.getSession());
            client.addCollection(parentPath, collectionName, mediaType, description);
        }
        catch (Exception e) {
            String msg = "Failed to add new collection " + collectionName + " to the parent collection " + parentPath + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new UIException(msg, (Throwable)e);
        }
        return parentPath;
    }
}

