/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.resource.stub.registry.service.RegistryAdminServiceStub;
import org.wso2.carbon.ui.CarbonUIUtil;

public class RegistryAdminServiceClient {
    private static final Log log = LogFactory.getLog(RegistryAdminServiceClient.class);
    private RegistryAdminServiceStub stub;
    private String epr;

    public RegistryAdminServiceClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws RegistryException {
        this.epr = backendServerURL + "RegistryAdminService";
        try {
            this.stub = new RegistryAdminServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate resource service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public RegistryAdminServiceClient(String cookie, ServletConfig config, HttpSession session) throws RegistryException {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "RegistryAdminService";
        try {
            this.stub = new RegistryAdminServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate resource service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public RegistryAdminServiceClient(ServletConfig config, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "RegistryAdminService";
        try {
            this.stub = new RegistryAdminServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate resource service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public String getHTTPPermalink(String path) {
        try {
            String httpPermalink = this.stub.getHTTPPermalink(path);
            if (httpPermalink != null) {
                return httpPermalink;
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to get permalink", (Throwable)e);
        }
        return "#";
    }

    public String getHTTPSPermalink(String path) {
        try {
            String httpsPermalink = this.stub.getHTTPSPermalink(path);
            if (httpsPermalink != null) {
                return httpsPermalink;
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to get permalink", (Throwable)e);
        }
        return "#";
    }
}

