/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.resource.stub.custom.CustomUIAdminServiceStub;
import org.wso2.carbon.ui.CarbonUIUtil;

public class CustomUIServiceClient {
    private static final Log log = LogFactory.getLog(CustomUIServiceClient.class);
    private CustomUIAdminServiceStub stub;
    private String epr;

    public CustomUIServiceClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws RegistryException {
        this.epr = backendServerURL + "CustomUIAdminService";
        try {
            this.stub = new CustomUIAdminServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate custom UI service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public CustomUIServiceClient(ServletConfig config, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "CustomUIAdminService";
        try {
            this.stub = new CustomUIAdminServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate custom UI service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public String getTextContent(String path) throws Exception {
        return this.stub.getTextContent(path);
    }

    public void updateTextContent(String path, String content) throws Exception {
        this.stub.updateTextContent(path, content);
    }

    public void addTextContent(String parentPath, String resourceName, String mediaType, String description, String content) throws Exception {
        this.stub.addTextContent(parentPath, resourceName, mediaType, description, content);
    }

    public boolean isAuthorized(String path, String action) throws Exception {
        return this.stub.isAuthorized(path, action);
    }
}

