/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.resource.ui;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.resource.stub.beans.xsd.CollectionContentBean;
import org.wso2.carbon.registry.resource.stub.beans.xsd.ResourceTreeEntryBean;
import org.wso2.carbon.registry.resource.ui.clients.ResourceServiceClient;
import org.wso2.carbon.ui.CarbonUIUtil;

public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);

    public static String[] getSortedChildNodes(CollectionContentBean bean) {
        return Utils.getSortedChildNodes(bean.getChildPaths());
    }

    public static String[] getSortedChildNodes(String[] childPaths) {
        if (childPaths == null || childPaths.length == 0) {
            return childPaths;
        }
        TreeMap<String, LinkedList<String>> sortedMap = new TreeMap<String, LinkedList<String>>();
        for (String childPath : childPaths) {
            LinkedList<String> childPathList = (LinkedList<String>)sortedMap.get(childPath.toLowerCase());
            if (childPathList == null) {
                childPathList = new LinkedList<String>();
            }
            childPathList.add(childPath);
            sortedMap.put(childPath.toLowerCase(), childPathList);
        }
        LinkedList<String> allChildPathList = new LinkedList<String>();
        for (List valueList : sortedMap.values()) {
            for (String value : valueList) {
                allChildPathList.add(value);
            }
        }
        return allChildPathList.toArray(new String[childPaths.length]);
    }

    public static String getResourceContentURL(HttpServletRequest request, String resourcePath) {
        ServletContext context = request.getSession().getServletContext();
        HttpSession session = request.getSession();
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)context, (HttpSession)session);
        String serverRoot = serverURL.substring(0, serverURL.length() - "services/".length());
        try {
            resourcePath = URLEncoder.encode(resourcePath, "UTF-8");
        }
        catch (UnsupportedEncodingException ignored) {
            // empty catch block
        }
        return serverRoot + "registry/resources?path=" + resourcePath;
    }

    public static String getResourceDownloadURL(HttpServletRequest request, String resourcePath) {
        resourcePath = resourcePath.replace("&", "%2526");
        return "../../registry/resourceContent?path=" + resourcePath;
    }

    public static String getResourceViewMode(HttpServletRequest request) {
        String mode = request.getParameter("resourceViewMode");
        if (mode == null) {
            mode = "";
        }
        return mode.trim();
    }

    public static String getResourceConsumer(HttpServletRequest request) {
        String consumer = request.getParameter("resourcePathConsumer");
        if (consumer == null) {
            consumer = "";
        }
        return consumer.trim();
    }

    public static String getResourcePath(HttpServletRequest request) {
        String path = request.getParameter("path");
        if (path == null) {
            path = "";
        }
        return path.trim();
    }

    public static String getSynapseRoot(HttpServletRequest request) {
        String path = request.getParameter("synapseroot");
        if (path == null) {
            path = "";
        }
        return path.trim();
    }

    public static String getTargetDivID(HttpServletRequest request) {
        String consumer = request.getParameter("targetDivID");
        if (consumer == null) {
            consumer = "";
        }
        return consumer.trim();
    }

    public static String resolveResourceKey(String completePath, String root) {
        if (completePath == null || "".equals(completePath)) {
            String msg = "Invalid path - Path cannot be null or empty";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        if (root == null || "".equals(root)) {
            return completePath;
        }
        if (!root.endsWith("/")) {
            root = root + "/";
        }
        if (completePath.startsWith(root)) {
            return completePath.substring(root.length(), completePath.length());
        }
        return "";
    }

    public static String buildReference(String resourcePath, ResourceServiceClient client, String rootName) {
        if (resourcePath == null || resourcePath.length() == 0 || resourcePath.equals("/")) {
            return rootName;
        }
        if (resourcePath.endsWith("/")) {
            resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
        }
        try {
            String[] parts = resourcePath.split("/");
            parts[0] = "";
            StringBuffer temp = new StringBuffer();
            StringBuffer reference = new StringBuffer(rootName);
            block2: for (int i = 0; i < parts.length - 1; ++i) {
                temp.append("/").append(parts[i]);
                ResourceTreeEntryBean resourceEntry = client.getResourceTreeEntry(temp.toString());
                if (resourceEntry.getCollection()) {
                    String[] childPaths = resourceEntry.getChildren();
                    for (int j = 0; j < childPaths.length; ++j) {
                        String childName = childPaths[j];
                        if (childName == null || childName.length() == 0) continue;
                        if (childName.endsWith("/")) {
                            childName = childName.substring(0, childName.length() - 1);
                        }
                        if (!(childName = childName.substring(childName.lastIndexOf("/") + 1)).equals(parts[i + 1])) continue;
                        reference.append("_").append(j);
                        continue block2;
                    }
                    continue;
                }
                return null;
            }
            return reference.toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

