/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.properties.services;

import org.wso2.carbon.registry.admin.api.properties.IPropertiesAdminService;
import org.wso2.carbon.registry.common.services.RegistryAbstractAdmin;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.properties.beans.PropertiesBean;
import org.wso2.carbon.registry.properties.beans.RetentionBean;
import org.wso2.carbon.registry.properties.utils.PropertiesBeanPopulator;

public class PropertiesAdminService
extends RegistryAbstractAdmin
implements IPropertiesAdminService<PropertiesBean, RetentionBean> {
    public PropertiesBean getProperties(String path, String viewProps) throws RegistryException {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        return PropertiesBeanPopulator.populate(registry, path, viewProps);
    }

    public void setProperty(String path, String name, String value) throws RegistryException {
        if (name != null && name.startsWith("registry.")) {
            throw new RegistryException("Property cannot start with the \"registry.\" prefix. Property name " + name + ". Resource path = " + path);
        }
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return;
        }
        Resource resource = registry.get(path);
        if (resource.getProperties().keySet().contains(name)) {
            throw new RegistryException("Cannot duplicate property name. Please choose a different name. Property name " + name + ". Resource path = " + path);
        }
        resource.addProperty(name, value);
        registry.put(resource.getPath(), resource);
        resource.discard();
    }

    public void updateProperty(String path, String name, String value, String oldName) throws RegistryException {
        if (name != null && name.startsWith("registry.")) {
            throw new RegistryException("Property cannot start with the \"registry.\" prefix. Property name " + name + ". Resource path = " + path);
        }
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return;
        }
        Resource resource = registry.get(path);
        if (resource.getProperties().keySet().contains(name) && !name.equals(oldName)) {
            throw new RegistryException("Cannot duplicate property name. Please choose a different name. Property name " + name + ". Resource path = " + path);
        }
        if (oldName.equals(name)) {
            resource.setProperty(name, value);
        } else {
            resource.setProperty(name, value);
            resource.removeProperty(oldName);
        }
        registry.put(resource.getPath(), resource);
        resource.discard();
    }

    public void removeProperty(String path, String name) throws RegistryException {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return;
        }
        Resource resource = registry.get(path);
        resource.removeProperty(name);
        registry.put(resource.getPath(), resource);
        resource.discard();
    }

    public boolean setRetentionProperties(String path, RetentionBean bean) throws RegistryException {
        if (path.matches(".*;version:\\d$")) {
            throw new RegistryException("User is not authorized to change retention properties of resource versions. Resource path = " + path);
        }
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return false;
        }
        Resource resource = registry.get(path);
        if (resource.getProperty("registry.retention.user.name") != null && !resource.getProperty("registry.retention.user.name").equals(registry.getUserName())) {
            throw new RegistryException("User is not authorized to change retention properties of this resource. Resource path = " + path);
        }
        if (bean == null) {
            resource.removeProperty("registry.retention.user.name");
            resource.removeProperty("registry.retention.fromDate");
            resource.removeProperty("registry.retention.toDate");
            resource.removeProperty("registry.retention.writeLocked");
            resource.removeProperty("registry.retention.deleteLocked");
        } else {
            resource.setProperty("registry.retention.user.name", registry.getUserName());
            resource.setProperty("registry.retention.fromDate", bean.getFromDate());
            resource.setProperty("registry.retention.toDate", bean.getToDate());
            resource.setProperty("registry.retention.writeLocked", String.valueOf(bean.getWriteLocked()));
            resource.setProperty("registry.retention.deleteLocked", String.valueOf(bean.getDeleteLocked()));
        }
        registry.put(resource.getPath(), resource);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RetentionBean getRetentionProperties(String path) throws RegistryException {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        Resource resource = registry.get(path);
        RetentionBean bean = new RetentionBean();
        ResourcePath resourcePath = new ResourcePath(path);
        String userName = resource.getProperty("registry.retention.user.name");
        if (userName == null) {
            if (resourcePath.isCurrentVersion()) return null;
            String originalPath = resourcePath.getPath();
            resource = registry.get(originalPath);
            userName = resource.getProperty("registry.retention.user.name");
            bean.setReadOnly(true);
        } else {
            bean.setReadOnly(!userName.equals(registry.getUserName()));
        }
        bean.setUserName(userName);
        bean.setFromDate(resource.getProperty("registry.retention.fromDate"));
        bean.setToDate(resource.getProperty("registry.retention.toDate"));
        bean.setWriteLocked(Boolean.parseBoolean(resource.getProperty("registry.retention.writeLocked")));
        bean.setDeleteLocked(Boolean.parseBoolean(resource.getProperty("registry.retention.deleteLocked")));
        return bean;
    }
}

