/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.reporting.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.ntask.core.AbstractTask;
import org.wso2.carbon.registry.app.RemoteRegistry;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.reporting.utils.Utils;

public class ReportingTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(ReportingTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        try {
            RemoteRegistry registry = new RemoteRegistry((String)this.getProperties().get("reporting.registry.url"), (String)this.getProperties().get("reporting.registry.username"), (String)this.getProperties().get("reporting.registry.password"));
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (Map.Entry e : this.getProperties().entrySet()) {
                if (((String)e.getKey()).startsWith("reporting.")) continue;
                attributes.put((String)e.getKey(), (String)e.getValue());
            }
            try {
                String type = (String)this.getProperties().get("reporting.type");
                ByteArrayOutputStream stream = Utils.getReportContentStream((String)this.getProperties().get("reporting.class"), (String)this.getProperties().get("reporting.template"), type, attributes, (Registry)registry);
                try {
                    Resource resource = registry.newResource();
                    resource.setContentStream((InputStream)new ByteArrayInputStream(stream.toByteArray()));
                    if (type.toLowerCase().equals("pdf")) {
                        resource.setMediaType("application/pdf");
                    } else if (type.toLowerCase().equals("excel")) {
                        resource.setMediaType("application/vnd.ms-excel");
                    } else if (type.toLowerCase().equals("html")) {
                        resource.setMediaType("application/html");
                    }
                    registry.put((String)this.getProperties().get("reporting.resource.path"), resource);
                }
                finally {
                    stream.close();
                }
            }
            catch (Exception e) {
                log.error((Object)"Unable to obtain reporting content stream", (Throwable)e);
            }
        }
        catch (MalformedURLException e) {
            log.error((Object)"Invalid Registry Connection URL", (Throwable)e);
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to connect to remote registry", (Throwable)e);
        }
    }
}

