/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.reporting.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.ntask.core.service.TaskService;

public class ReportingServiceComponent {
    private static final Log log = LogFactory.getLog(ReportingServiceComponent.class);
    private static final String REPORTING_TASK_MANAGER = "registryReportingTasks";
    private static TaskService taskService;

    protected void activate(ComponentContext context) {
        log.debug((Object)"******* Registry Reporting bundle is activated ******* ");
    }

    protected void deactivate(ComponentContext context) {
        log.debug((Object)"******* Registry Reporting bundle is deactivated ******* ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskManager getTaskManager(int tenantId) {
        TaskManager taskManager;
        SuperTenantCarbonContext.startTenantFlow();
        try {
            SuperTenantCarbonContext.getCurrentContext().setTenantId(tenantId);
            taskManager = taskService.getTaskManager(REPORTING_TASK_MANAGER);
        }
        catch (Throwable throwable) {
            try {
                SuperTenantCarbonContext.endTenantFlow();
                throw throwable;
            }
            catch (TaskException e) {
                log.error((Object)"Unable to obtain task manager", (Throwable)e);
                return null;
            }
        }
        SuperTenantCarbonContext.endTenantFlow();
        return taskManager;
    }

    public void setTaskService(TaskService taskService) {
        ReportingServiceComponent.updateTaskService(taskService);
    }

    public void unsetTaskService(TaskService taskService) {
        ReportingServiceComponent.updateTaskService(null);
    }

    private static void updateTaskService(TaskService service) {
        taskService = service;
    }
}

