/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.reporting.services;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.registry.admin.api.reporting.IReportingAdminService;
import org.wso2.carbon.registry.common.beans.ReportConfigurationBean;
import org.wso2.carbon.registry.common.services.RegistryAbstractAdmin;
import org.wso2.carbon.registry.common.utils.CommonUtil;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.reporting.annotation.Property;
import org.wso2.carbon.registry.reporting.internal.ReportingServiceComponent;
import org.wso2.carbon.registry.reporting.utils.ReportingTask;
import org.wso2.carbon.registry.reporting.utils.Utils;

public class ReportingAdminService
extends RegistryAbstractAdmin
implements IReportingAdminService<ReportConfigurationBean> {
    public static final String REPORTING_CONFIG_PATH = "/repository/components/org.wso2.carbon.registry.reporting/configurations/";

    public byte[] getReportBytes(ReportConfigurationBean configuration) throws Exception {
        return Utils.getReportContentStream(configuration.getReportClass(), configuration.getTemplate(), configuration.getType(), CommonUtil.attributeArrayToMap((String[])configuration.getAttributes()), this.getRootRegistry()).toByteArray();
    }

    public void scheduleReport(ReportConfigurationBean configuration) throws Exception {
        HashMap<String, String> propertyMap = new HashMap<String, String>(CommonUtil.attributeArrayToMap((String[])configuration.getAttributes()));
        propertyMap.put("reporting.registry.url", configuration.getRegistryURL());
        propertyMap.put("reporting.registry.username", configuration.getUsername());
        propertyMap.put("reporting.registry.password", configuration.getPassword());
        propertyMap.put("reporting.type", configuration.getType());
        propertyMap.put("reporting.class", configuration.getReportClass());
        propertyMap.put("reporting.template", configuration.getTemplate());
        propertyMap.put("reporting.resource.path", configuration.getResourcePath());
        String clazz = ReportingTask.class.getName();
        TaskManager taskManager = ReportingServiceComponent.getTaskManager(((UserRegistry)this.getRootRegistry()).getTenantId());
        taskManager.registerTask(new TaskInfo(configuration.getName(), clazz, propertyMap, new TaskInfo.TriggerInfo(configuration.getCronExpression())));
        taskManager.rescheduleTask(configuration.getName());
        this.saveReport(configuration);
    }

    public void stopScheduledReport(String name) throws Exception {
        TaskManager taskManager = ReportingServiceComponent.getTaskManager(((UserRegistry)this.getRootRegistry()).getTenantId());
        taskManager.pauseTask(name);
        taskManager.deleteTask(name);
    }

    public void saveReport(ReportConfigurationBean configuration) throws RegistryException, CryptoException {
        Registry registry = this.getConfigSystemRegistry();
        Resource resource = registry.newResource();
        resource.setMediaType("application/vnd.wso2.registry-report");
        if (configuration.getCronExpression() != null) {
            resource.setProperty("cronExpression", configuration.getCronExpression());
        } else {
            resource.setProperty("cronExpression", "");
        }
        if (configuration.getReportClass() != null) {
            resource.setProperty("class", configuration.getReportClass());
        } else {
            resource.setProperty("class", "");
        }
        if (configuration.getResourcePath() != null) {
            resource.setProperty("resourcePath", configuration.getResourcePath());
        } else {
            resource.setProperty("resourcePath", "");
        }
        if (configuration.getTemplate() != null) {
            resource.setProperty("template", configuration.getTemplate());
        } else {
            resource.setProperty("template", "");
        }
        if (configuration.getType() != null) {
            resource.setProperty("type", configuration.getType());
        } else {
            resource.setProperty("type", "");
        }
        if (configuration.getRegistryURL() != null) {
            resource.setProperty("registry.url", configuration.getRegistryURL());
        } else {
            resource.setProperty("registry.url", "");
        }
        if (configuration.getUsername() != null) {
            resource.setProperty("registry.username", configuration.getUsername());
        } else {
            resource.setProperty("registry.username", "");
        }
        if (configuration.getPassword() != null) {
            resource.setProperty("registry.password", CryptoUtil.getDefaultCryptoUtil().encryptAndBase64Encode(configuration.getPassword().getBytes()));
        } else {
            resource.setProperty("registry.password", CryptoUtil.getDefaultCryptoUtil().encryptAndBase64Encode("".getBytes()));
        }
        for (Map.Entry e : CommonUtil.attributeArrayToMap((String[])configuration.getAttributes()).entrySet()) {
            resource.setProperty("attribute." + (String)e.getKey(), (String)e.getValue());
        }
        registry.put(REPORTING_CONFIG_PATH + configuration.getName(), resource);
    }

    public ReportConfigurationBean[] getSavedReports() throws RegistryException, CryptoException, TaskException {
        Registry registry = this.getConfigSystemRegistry();
        LinkedList<ReportConfigurationBean> output = new LinkedList<ReportConfigurationBean>();
        if (registry.resourceExists(REPORTING_CONFIG_PATH)) {
            String[] children;
            Collection collection = (Collection)registry.get(REPORTING_CONFIG_PATH);
            for (String child : children = collection.getChildren()) {
                ReportConfigurationBean bean = this.getConfigurationBean(child);
                output.add(bean);
            }
        }
        return output.toArray(new ReportConfigurationBean[output.size()]);
    }

    public ReportConfigurationBean getSavedReport(String name) throws RegistryException, CryptoException, TaskException {
        return this.getConfigurationBean(REPORTING_CONFIG_PATH + name);
    }

    public void deleteSavedReport(String name) throws RegistryException {
        this.getConfigSystemRegistry().delete("/repository/components/org.wso2.carbon.registry.reporting/configurations//" + name);
    }

    public void copySavedReport(String name, String newName) throws RegistryException {
        this.getConfigSystemRegistry().copy("/repository/components/org.wso2.carbon.registry.reporting/configurations//" + name, "/repository/components/org.wso2.carbon.registry.reporting/configurations//" + newName);
    }

    private ReportConfigurationBean getConfigurationBean(String path) throws RegistryException, CryptoException, TaskException {
        Registry registry = this.getConfigSystemRegistry();
        Resource resource = registry.get(path);
        ReportConfigurationBean bean = new ReportConfigurationBean();
        String name = RegistryUtils.getResourceName((String)path);
        bean.setName(name);
        bean.setCronExpression(resource.getProperty("cronExpression"));
        TaskManager taskManager = ReportingServiceComponent.getTaskManager(((UserRegistry)this.getRootRegistry()).getTenantId());
        bean.setScheduled(taskManager.isTaskScheduled(name));
        bean.setReportClass(resource.getProperty("class"));
        bean.setResourcePath(resource.getProperty("resourcePath"));
        bean.setTemplate(resource.getProperty("template"));
        bean.setType(resource.getProperty("type"));
        bean.setRegistryURL(resource.getProperty("registry.url"));
        bean.setUsername(resource.getProperty("registry.username"));
        bean.setPassword(new String(CryptoUtil.getDefaultCryptoUtil().base64DecodeAndDecrypt(resource.getProperty("registry.password"))));
        HashMap<String, String> attributes = new HashMap<String, String>();
        Properties props = resource.getProperties();
        for (Object key : props.keySet()) {
            String propKey = (String)key;
            if (!propKey.startsWith("attribute.")) continue;
            attributes.put(propKey.substring("attribute.".length()), resource.getProperty(propKey));
        }
        bean.setAttributes(CommonUtil.mapToAttributeArray(attributes));
        return bean;
    }

    public String[] getAttributeNames(String className) throws Exception {
        Method[] declaredMethods;
        LinkedList<String> output = new LinkedList<String>();
        for (Method method : declaredMethods = RegistryUtils.loadClass((String)className).getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Property.class)) continue;
            String name = method.getName();
            if (name.startsWith("set")) {
                name = name.substring("set".length());
            }
            output.add(name.substring(0, 1).toLowerCase() + name.substring(1));
        }
        return output.toArray(new String[output.size()]);
    }

    public String[] getMandatoryAttributeNames(String className) throws Exception {
        Method[] declaredMethods;
        LinkedList<String> output = new LinkedList<String>();
        for (Method method : declaredMethods = RegistryUtils.loadClass((String)className).getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Property.class) || !method.getAnnotation(Property.class).mandatory()) continue;
            String name = method.getName();
            if (name.startsWith("set")) {
                name = name.substring("set".length());
            }
            output.add(name.substring(0, 1).toLowerCase() + name.substring(1));
        }
        return output.toArray(new String[output.size()]);
    }
}

