/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.reporting.ui.clients;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.common.utils.CommonUtil;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.reporting.stub.beans.xsd.ReportConfigurationBean;
import org.wso2.carbon.registry.reporting.ui.clients.ReportGeneratorClient;

public class ReportGeneratorServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(ReportGeneratorServlet.class);
    private ServletConfig servletConfig;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.servletConfig = servletConfig;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            ReportGeneratorServlet.getContent(request, response, this.servletConfig);
        }
        catch (Exception e) {
            String msg = "Failed to generate report content.";
            log.error((Object)msg, (Throwable)e);
            response.setStatus(500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getContent(HttpServletRequest request, HttpServletResponse response, ServletConfig config) throws Exception {
        try {
            String extension;
            String mediaType;
            String attributes;
            String reportClass;
            String reportType;
            ReportGeneratorClient client = new ReportGeneratorClient(request, config);
            ReportConfigurationBean bean = client.getSavedReport(request.getParameter("reportName"));
            String reportTemplate = request.getParameter("reportTemplate");
            if (reportTemplate != null) {
                bean.setTemplate(reportTemplate);
            }
            if ((reportType = request.getParameter("reportType")) != null) {
                bean.setType(reportType);
            }
            if ((reportClass = request.getParameter("reportClass")) != null) {
                bean.setReportClass(reportClass);
            }
            if ((attributes = request.getParameter("attributes")) != null && attributes.length() > 0) {
                String[] attributeStrings;
                Map attributeMap = CommonUtil.attributeArrayToMap((String[])bean.getAttributes());
                attributes = attributes.substring(0, attributes.length() - 1);
                for (String temp : attributeStrings = attributes.split("\\^")) {
                    String[] pair = temp.split("\\|");
                    attributeMap.put(pair[0].substring("attribute".length()), pair[1]);
                }
                bean.setAttributes(CommonUtil.mapToAttributeArray((Map)attributeMap));
            }
            response.setDateHeader("Last-Modified", new Date().getTime());
            if (bean.getType().toLowerCase().equals("pdf")) {
                mediaType = "application/pdf";
                extension = ".pdf";
            } else if (bean.getType().toLowerCase().equals("excel")) {
                mediaType = "application/vnd.ms-excel";
                extension = ".xls";
            } else if (bean.getType().toLowerCase().equals("html")) {
                mediaType = "application/html";
                extension = ".html";
            } else {
                mediaType = "application/download";
                extension = "";
            }
            response.setHeader("Content-Disposition", "attachment; filename=\"" + bean.getName() + extension + "\"");
            response.setContentType(mediaType);
            ServletOutputStream servletOutputStream = response.getOutputStream();
            try {
                client.getReportBytes(bean).writeTo((OutputStream)servletOutputStream);
                response.flushBuffer();
                servletOutputStream.flush();
            }
            finally {
                if (servletOutputStream != null) {
                    servletOutputStream.close();
                }
            }
        }
        catch (RegistryException e) {
            String msg = "Failed to get resource content. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            response.setStatus(500);
        }
    }
}

