/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.reporting.ui.clients;

import javax.activation.DataHandler;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.reporting.stub.ReportingAdminServiceStub;
import org.wso2.carbon.registry.reporting.stub.beans.xsd.ReportConfigurationBean;
import org.wso2.carbon.ui.CarbonUIUtil;

public class ReportGeneratorClient {
    private static final Log log = LogFactory.getLog(ReportGeneratorClient.class);
    private ReportingAdminServiceStub stub = null;

    public ReportGeneratorClient(HttpServletRequest request, ServletConfig config) {
        HttpSession session = request.getSession();
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String epr = backendServerURL + "ReportingAdminService";
        try {
            this.stub = new ReportingAdminServiceStub(configContext, epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault e) {
            log.error((Object)"Failed to initiate report generator client.", (Throwable)e);
        }
    }

    public DataHandler getReportBytes(ReportConfigurationBean configuration) throws Exception {
        return this.stub.getReportBytes(configuration);
    }

    public void scheduleReport(ReportConfigurationBean configuration) throws Exception {
        this.stub.scheduleReport(configuration);
    }

    public void stopScheduledReport(String name) throws Exception {
        this.stub.stopScheduledReport(name);
    }

    public void saveReport(ReportConfigurationBean configuration) throws Exception {
        this.stub.saveReport(configuration);
    }

    public ReportConfigurationBean[] getSavedReports() throws Exception {
        ReportConfigurationBean[] savedReports = this.stub.getSavedReports();
        if (savedReports == null || savedReports[0] == null) {
            savedReports = new ReportConfigurationBean[]{};
        }
        return savedReports;
    }

    public ReportConfigurationBean getSavedReport(String name) throws Exception {
        return this.stub.getSavedReport(name);
    }

    public void deleteSavedReport(String name) throws Exception {
        this.stub.deleteSavedReport(name);
    }

    public void copySavedReport(String name, String newName) throws Exception {
        this.stub.copySavedReport(name, newName);
    }

    public String[] getAttributeNames(String className) throws Exception {
        return this.stub.getAttributeNames(className);
    }

    public String[] getMandatoryAttributeNames(String className) throws Exception {
        return this.stub.getMandatoryAttributeNames(className);
    }
}

