/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.reporting.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.reporting.AbstractReportGenerator;
import org.wso2.carbon.registry.reporting.annotation.Property;

public class Utils {
    public static ByteArrayOutputStream getReportContentStream(String reportClass, String template, String type, Map<String, String> attributes, Registry registry) throws Exception {
        Method[] declaredMethods;
        AbstractReportGenerator reportGenerator = (AbstractReportGenerator)RegistryUtils.loadClass((String)reportClass).newInstance();
        reportGenerator.setRegistry(registry);
        for (Method method : declaredMethods = reportGenerator.getClass().getDeclaredMethods()) {
            String value;
            if (!method.isAnnotationPresent(Property.class)) continue;
            String name = method.getName();
            if (name.startsWith("set")) {
                name = name.substring("set".length());
            }
            if ((value = attributes.get(name = name.substring(0, 1).toLowerCase() + name.substring(1))) == null && method.getAnnotation(Property.class).mandatory()) {
                throw new IOException("A mandatory field " + name + " was not set");
            }
            method.invoke((Object)reportGenerator, value);
        }
        return reportGenerator.execute(template, type);
    }
}

