/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.relations.services.utils;

import java.util.List;
import org.wso2.carbon.registry.common.utils.UserUtil;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.relations.beans.AssociationBean;
import org.wso2.carbon.registry.relations.beans.DependenciesBean;
import org.wso2.carbon.registry.relations.services.utils.CommonUtil;

public class DependenciesBeanPopulator {
    public static DependenciesBean populate(UserRegistry userRegistry, String path) {
        DependenciesBean dependenciesBean = new DependenciesBean();
        ResourcePath resourcePath = new ResourcePath(path);
        try {
            Association[] asso = CommonUtil.getAssociations((Registry)userRegistry, resourcePath.isCurrentVersion() ? resourcePath.getPath() : resourcePath.getPathWithVersion());
            Resource resource = userRegistry.get(path);
            AssociationBean[] beans = new AssociationBean[asso.length];
            for (int i = 0; i < beans.length; ++i) {
                Association as = asso[i];
                beans[i] = new AssociationBean(as.getSourcePath(), as.getDestinationPath(), as.getAssociationType());
            }
            dependenciesBean.setAssociationBeans(beans);
            dependenciesBean.setVersionView(!resourcePath.isCurrentVersion());
            dependenciesBean.setPathWithVersion(resourcePath.getPathWithVersion());
            List mountPoints = resource.getPropertyValues("registry.mountpoint");
            List targetPoints = resource.getPropertyValues("registry.targetpoint");
            List actualPaths = resource.getPropertyValues("registry.actualpath");
            String user = resource.getProperty("registry.user");
            if (resource.getProperty("registry.link") != null) {
                if (mountPoints != null && targetPoints != null) {
                    String tempPath = (String)actualPaths.get(0);
                    dependenciesBean.setPutAllowed(UserUtil.isPutAllowed((String)userRegistry.getUserName(), (String)tempPath, (UserRegistry)userRegistry));
                } else if (user != null) {
                    if (userRegistry.getUserName().equals(user)) {
                        dependenciesBean.setPutAllowed(true);
                    } else {
                        dependenciesBean.setPutAllowed(UserUtil.isPutAllowed((String)userRegistry.getUserName(), (String)path, (UserRegistry)userRegistry));
                    }
                }
            } else {
                dependenciesBean.setPutAllowed(UserUtil.isPutAllowed((String)userRegistry.getUserName(), (String)path, (UserRegistry)userRegistry));
            }
            dependenciesBean.setLoggedIn(!"wso2.anonymous.user".equals(userRegistry.getUserName()));
        }
        catch (RegistryException e) {
            String msg = "Failed to get dependencies of resource " + resourcePath + ". " + e.getMessage();
            dependenciesBean.setErrorMessage(msg);
        }
        return dependenciesBean;
    }
}

