/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.relations.services.utils;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;

public class CommonUtil {
    private static final Log log = LogFactory.getLog(CommonUtil.class);
    private static RegistryService registryService;

    public static synchronized void setRegistryService(RegistryService service) {
        registryService = service;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static Association[] getAssociations(Registry registry, String path) throws RegistryException {
        Association[] asso = registry.getAllAssociations(path);
        if (asso == null || asso.length == 0) {
            return asso;
        }
        LinkedList<Association> assoList = new LinkedList<Association>();
        for (Association a : asso) {
            if (a.getDestinationPath() == null || !registry.resourceExists(a.getDestinationPath()) && !a.getDestinationPath().matches("^[a-zA-Z]+://.*")) continue;
            assoList.add(a);
        }
        if (assoList.size() == 0) {
            return new Association[0];
        }
        Arrays.sort(assoList.toArray(new Association[assoList.size()]), new Comparator<Association>(){

            @Override
            public int compare(Association o1, Association o2) {
                return o1.getDestinationPath().compareTo(o2.getDestinationPath());
            }
        });
        return assoList.toArray(new Association[assoList.size()]);
    }
}

