/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.relations.services;

import org.wso2.carbon.registry.admin.api.relations.IRelationService;
import org.wso2.carbon.registry.common.services.RegistryAbstractAdmin;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.relations.beans.AssociationTreeBean;
import org.wso2.carbon.registry.relations.beans.DependenciesBean;
import org.wso2.carbon.registry.relations.services.utils.AssociationTreeBeanPopulator;
import org.wso2.carbon.registry.relations.services.utils.DependenciesBeanPopulator;

public class RelationService
extends RegistryAbstractAdmin
implements IRelationService {
    public DependenciesBean getDependencies(String path) throws RegistryException {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        return DependenciesBeanPopulator.populate(registry, path);
    }

    public void addAssociation(String path, String type, String associationPaths, String todo) throws RegistryException {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return;
        }
        if (todo.equals("add")) {
            registry.addAssociation(path, associationPaths, type);
        } else {
            registry.removeAssociation(path, associationPaths, type);
        }
        DependenciesBeanPopulator.populate(registry, path);
    }

    public AssociationTreeBean getAssociationTree(String path, String type) throws RegistryException {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        return AssociationTreeBeanPopulator.populate(registry, path, type);
    }
}

