/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.relations.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.relations.stub.RelationAdminServiceStub;
import org.wso2.carbon.registry.relations.stub.beans.xsd.AssociationBean;
import org.wso2.carbon.registry.relations.stub.beans.xsd.AssociationTreeBean;
import org.wso2.carbon.registry.relations.stub.beans.xsd.DependenciesBean;
import org.wso2.carbon.ui.CarbonUIUtil;

public class RelationServiceClient {
    private static final Log log = LogFactory.getLog(RelationServiceClient.class);
    private RelationAdminServiceStub stub;
    private String epr;

    public RelationServiceClient(String cookie, ServletConfig config, HttpSession session) throws RegistryException {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "RelationAdminService";
        try {
            this.stub = new RelationAdminServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate comment service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public DependenciesBean getDependencies(HttpServletRequest request) throws Exception {
        String path = request.getParameter("path");
        DependenciesBean bean = null;
        try {
            bean = this.stub.getDependencies(path);
            if (bean.getAssociationBeans() == null) {
                bean.setAssociationBeans(new AssociationBean[0]);
            }
        }
        catch (Exception e) {
            String msg = "Failed to get associations from the service. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
        return bean;
    }

    public void addAssociation(HttpServletRequest request) throws Exception {
        String path = request.getParameter("path");
        String type = request.getParameter("type");
        String associationPaths = request.getParameter("associationPaths");
        String todo = request.getParameter("todo");
        try {
            this.stub.addAssociation(path, type, associationPaths, todo);
        }
        catch (Exception e) {
            String msg = "Failed to add associations. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
    }

    public AssociationTreeBean getAssociationTree(HttpServletRequest request) throws Exception {
        String path = request.getParameter("path");
        String type = request.getParameter("type");
        AssociationTreeBean bean = null;
        try {
            bean = this.stub.getAssociationTree(path, type);
        }
        catch (Exception e) {
            String msg = "Failed to get association tree. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg);
        }
        return bean;
    }
}

