/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.properties.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.common.utils.UserUtil;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.properties.beans.PropertiesBean;
import org.wso2.carbon.registry.properties.utils.Property;

public class PropertiesBeanPopulator {
    public static PropertiesBean populate(UserRegistry registry, String path, String viewProps) throws RegistryException {
        Property[] propArray;
        Resource resource = registry.get(path);
        ResourcePath resourcePath = new ResourcePath(path);
        PropertiesBean propertiesBean = new PropertiesBean();
        boolean isPutAllowed = false;
        if (CarbonContext.getCurrentContext().getUsername() != null && !CarbonContext.getCurrentContext().getUsername().equals(resource.getProperty("registry.retention.user.name")) && Boolean.parseBoolean(resource.getProperty("registry.retention.writeLocked"))) {
            propertiesBean.setWriteLocked(resource.getProperty("registry.retention.writeLocked"));
            propertiesBean.setDeleteLocked(resource.getProperty("registry.retention.deleteLocked"));
        } else {
            propertiesBean.setWriteLocked("false");
            propertiesBean.setDeleteLocked("false");
        }
        Properties properties = resource.getProperties();
        Set<Object> keySet = properties.keySet();
        if (keySet.size() != 0) {
            Object[] keys = keySet.toArray();
            propArray = new Property[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                Property prop = new Property();
                prop.setKey((String)keys[i]);
                List values = (List)properties.get((String)keys[i]);
                prop.setValue((String)values.get(0));
                propArray[i] = prop;
                if (!keys[i].equals("registry.link") || !values.get(0).equals("true")) continue;
                isPutAllowed = true;
            }
        } else {
            propArray = new Property[]{};
        }
        propertiesBean.setProperties(propArray);
        Boolean viewSysProps = false;
        if (viewProps.equalsIgnoreCase("yes")) {
            viewSysProps = true;
        }
        Iterator<Object> iTmpProps = resource.getProperties().keySet().iterator();
        ArrayList<String> sysProperties = new ArrayList<String>();
        ArrayList<String> validationProperties = new ArrayList<String>();
        ArrayList<String> lifecycleProperties = new ArrayList<String>();
        while (iTmpProps.hasNext()) {
            String name = (String)iTmpProps.next();
            if (viewSysProps != null && viewSysProps.booleanValue() || !name.startsWith("registry.")) {
                sysProperties.add(name);
            }
            if (name.startsWith("registry.wsdl") || name.startsWith("registry.wsi")) {
                validationProperties.add(name);
                continue;
            }
            if (!name.startsWith("registry.lifecycle.") && !name.equals("registry.Aspects")) continue;
            lifecycleProperties.add(name);
        }
        Collections.sort(sysProperties);
        String[] sysProps = new String[sysProperties.size()];
        for (int i = 0; i < sysProperties.size(); ++i) {
            sysProps[i] = (String)sysProperties.get(i);
        }
        propertiesBean.setSysProperties(sysProps);
        String[] validationProps = new String[validationProperties.size()];
        for (int i = 0; i < validationProperties.size(); ++i) {
            validationProps[i] = (String)validationProperties.get(i);
        }
        propertiesBean.setValidationProperties(validationProps);
        String[] lifecycleProps = new String[lifecycleProperties.size()];
        for (int i = 0; i < lifecycleProperties.size(); ++i) {
            lifecycleProps[i] = (String)lifecycleProperties.get(i);
        }
        propertiesBean.setLifecycleProperties(lifecycleProps);
        propertiesBean.setVersionView(!resourcePath.isCurrentVersion());
        propertiesBean.setPathWithVersion(resourcePath.getPathWithVersion());
        if (!isPutAllowed) {
            isPutAllowed = UserUtil.isPutAllowed((String)registry.getUserName(), (String)path, (UserRegistry)registry);
        }
        propertiesBean.setPutAllowed(isPutAllowed);
        propertiesBean.setLoggedIn(!"wso2.anonymous.user".equals(registry.getUserName()));
        return propertiesBean;
    }
}

