/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.profiles.services;

import org.wso2.carbon.registry.admin.api.profiles.IProfilesAdminService;
import org.wso2.carbon.registry.common.services.RegistryAbstractAdmin;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.profiles.beans.ProfilesBean;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.Claim;

public class ProfilesAdminService
extends RegistryAbstractAdmin
implements IProfilesAdminService<ProfilesBean> {
    public boolean putUserProfile(String path) throws RegistryException, UserStoreException {
        String[] profilenames;
        String[] userRoles;
        Registry registry = this.getConfigSystemRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return false;
        }
        String[] allpath = path.split("/");
        String username = allpath[allpath.length - 2];
        UserRegistry userRegistry = (UserRegistry)this.getRootRegistry();
        UserRealm realm = userRegistry.getUserRealm();
        boolean isAdmin = false;
        for (String userRole : userRoles = realm.getUserStoreManager().getRoleListOfUser(userRegistry.getUserName())) {
            if (!userRole.equals(realm.getRealmConfiguration().getAdminRoleName())) continue;
            isAdmin = true;
            break;
        }
        if (username == null || !username.equals(userRegistry.getUserName()) && !isAdmin) {
            return false;
        }
        UserStoreManager userprofile = realm.getUserStoreManager();
        int total = 0;
        int empty = 0;
        if (!userprofile.isExistingUser(username)) {
            return false;
        }
        for (String temp : profilenames = userprofile.getProfileNames(username)) {
            Claim[] claimobjs;
            for (Claim tmpclaims : claimobjs = userprofile.getUserClaimValues(username, temp)) {
                ++total;
                if (tmpclaims.getValue() != null) continue;
                ++empty;
            }
        }
        if (empty == total) {
            return false;
        }
        Resource resource = null;
        if (registry.resourceExists(path)) {
            return false;
        }
        resource = registry.newResource();
        resource.setMediaType("application/vnd.wso2-profiles");
        registry.put(path, resource);
        String everyoneRole = realm.getRealmConfiguration().getEveryOneRoleName();
        try {
            realm.getAuthorizationManager().denyRole(everyoneRole, "/_system/config" + path, "http://www.wso2.org/projects/registry/actions/get");
            realm.getAuthorizationManager().authorizeUser(username, "/_system/config" + path, "http://www.wso2.org/projects/registry/actions/get");
        }
        catch (UserStoreException e) {
            throw e;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public ProfilesBean getUserProfile(String path) throws RegistryException, UserStoreException {
        Registry registry = this.getConfigSystemRegistry();
        Resource resource = registry.get(path);
        String contentString = (String)resource.getContent();
        ProfilesBean profbean = new ProfilesBean();
        profbean.setMainDataString(contentString);
        return profbean;
    }
}

