/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.profiles.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.registry.app.RemoteRegistryService;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.Filter;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.URLMatcher;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.profiles.handlers.ProfilesAddHandler;
import org.wso2.carbon.registry.profiles.utils.CommonUtil;

public class RegistryMgtUIProfilesServiceComponent {
    private static Log log = LogFactory.getLog(RegistryMgtUIProfilesServiceComponent.class);
    private Registry registry = null;

    protected void activate(ComponentContext context) {
        log.debug((Object)"******* Registry Profiles Management bundle is activated ******* ");
    }

    protected void deactivate(ComponentContext context) {
        log.debug((Object)"Registry Profiles Management bundle is deactivated ");
    }

    protected void setRegistryService(RegistryService registryService) {
        CommonUtil.setRegistryService(registryService);
        if (registryService instanceof RemoteRegistryService) {
            log.warn((Object)"Profiles are not available on Remote Registry");
            return;
        }
        try {
            UserRegistry configSystemRegistry = registryService.getConfigSystemRegistry();
            if (this.registry != null && this.registry == configSystemRegistry) {
                return;
            }
            this.registry = configSystemRegistry;
            if (this.registry == null || this.registry.getRegistryContext() == null || this.registry.getRegistryContext().getHandlerManager() == null) {
                String msg = "Error Initializing Registry Profile Handler";
                log.error((Object)msg);
            } else {
                URLMatcher filter = new URLMatcher();
                filter.setGetPattern(RegistryUtils.getAbsolutePath((RegistryContext)this.registry.getRegistryContext(), (String)"/") + ".*" + "/users/" + ".*/profiles");
                filter.setPutPattern(RegistryUtils.getAbsolutePath((RegistryContext)this.registry.getRegistryContext(), (String)"/") + ".*" + "/users/" + ".*/profiles");
                ProfilesAddHandler handler = new ProfilesAddHandler();
                this.registry.getRegistryContext().getHandlerManager().addHandler(null, (Filter)filter, (Handler)handler);
            }
        }
        catch (Exception e) {
            String msg = "Error Initializing Registry Profiles Handler";
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        CommonUtil.setRegistryService(null);
    }
}

