/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.profiles.handlers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.Claim;

public class ProfilesAddHandler
extends Handler {
    private static final Log log = LogFactory.getLog(ProfilesAddHandler.class);

    public void put(RequestContext requestContext) throws RegistryException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource get(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return null;
        }
        CommonUtil.acquireUpdateLock();
        try {
            UserStoreManager userStoreManager;
            ResourceImpl col;
            String username;
            String path;
            block13: {
                path = requestContext.getResourcePath().getPath();
                String[] pathParts = path.split("/");
                username = pathParts[pathParts.length - 2];
                col = null;
                UserRealm realm = CurrentSession.getUserRealm();
                userStoreManager = realm.getUserStoreManager();
                if (userStoreManager.isExistingUser(username)) break block13;
                if (username.equals("users")) {
                    log.error((Object)("No user with the username:" + username + " in the User Manager"));
                }
                Resource resource = null;
                return resource;
            }
            try {
                String[] profileNames;
                StringBuffer resourceContent = new StringBuffer();
                for (String temp : profileNames = userStoreManager.getProfileNames(username)) {
                    Claim[] claimValues = userStoreManager.getUserClaimValues(username, temp);
                    if (claimValues.length != 0) {
                        resourceContent.append(temp).append("%");
                        for (Claim claim : claimValues) {
                            resourceContent.append(claim.getDisplayTag()).append(";").append(claim.getValue()).append(";");
                        }
                    }
                    resourceContent.append("#");
                }
                Registry registry = requestContext.getRegistry();
                if (registry.resourceExists(path)) {
                    col = (ResourceImpl)registry.get(path);
                    col.setContent((Object)resourceContent.toString());
                }
            }
            catch (UserStoreException e) {
                log.error((Object)"An error occurred while reading profile details", (Throwable)e);
            }
            ResourceImpl resourceImpl = col;
            return resourceImpl;
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }
}

