/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.profiles.ui.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.common.ui.UIException;
import org.wso2.carbon.registry.profiles.stub.beans.xsd.ProfilesBean;
import org.wso2.carbon.registry.profiles.ui.clients.ProfilesAdminServiceClient;

public class GetProfileUtil {
    private static final Log log = LogFactory.getLog(GetProfileUtil.class);

    public static Map<String, Map<String, String>> getProfile(String path, ServletConfig config, HttpSession session) throws UIException {
        try {
            ProfilesAdminServiceClient client = new ProfilesAdminServiceClient(config, session);
            ProfilesBean bean = client.getUserProfile(path);
            if (bean == null || bean.getMainDataString() == null) {
                log.error((Object)("The profile was not found for the path " + path));
                return null;
            }
            HashMap<String, Map<String, String>> data = new HashMap<String, Map<String, String>>();
            String maindatastring = bean.getMainDataString();
            String[] profile = maindatastring.split("#");
            HashMap<String, String> pair = null;
            for (int i = 0; i < profile.length; ++i) {
                String[] inter;
                if (profile[i].equals("") || (inter = profile[i].split("%")) == null || inter.length <= 1) continue;
                String[] inter1 = inter[1].split(";");
                pair = new HashMap<String, String>();
                for (int j = 0; j < inter1.length; j += 2) {
                    pair.put(inter1[j], inter1[j + 1]);
                }
                data.put(inter[0], pair);
            }
            return data;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            return null;
        }
    }

    public static String getprofilename(Map<String, Map<String, String>> data) {
        Set<String> profiles = data.keySet();
        if (data.get("default") != null) {
            return "default";
        }
        for (String profile : profiles) {
            if (profile == null) continue;
            return profile;
        }
        return null;
    }

    public static Map<String, String> getprofiledatatoshow(Map<String, Map<String, String>> data, String profilename) {
        return data.get(profilename);
    }
}

