/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.profiles.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.profiles.stub.ProfilesAdminServiceStub;
import org.wso2.carbon.registry.profiles.stub.beans.xsd.ProfilesBean;
import org.wso2.carbon.ui.CarbonUIUtil;

public class ProfilesAdminServiceClient {
    private static final Log log = LogFactory.getLog(ProfilesAdminServiceClient.class);
    private ProfilesAdminServiceStub stub;
    private String epr;

    public ProfilesAdminServiceClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws RegistryException {
        this.epr = backendServerURL + "ProfilesAdminService";
        try {
            this.stub = new ProfilesAdminServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate ProfilesAdmin service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public ProfilesAdminServiceClient(ServletConfig config, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "ProfilesAdminService";
        try {
            this.stub = new ProfilesAdminServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate ProfilesAdmin service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public ProfilesBean getUserProfile(String path) throws Exception {
        return this.stub.getUserProfile(path);
    }

    public boolean putUserProfile(String path) throws Exception {
        return this.stub.putUserProfile(path);
    }
}

