/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.handler.util;

import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Comment;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.config.RegistryConfigurationProcessor;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.Filter;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.service.SimulationService;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.handler.beans.FilterConfigurationBean;
import org.wso2.carbon.registry.handler.beans.HandlerConfigurationBean;
import org.wso2.carbon.registry.handler.beans.HandlerExecutionStatus;
import org.wso2.carbon.registry.handler.beans.SimulationRequest;
import org.wso2.carbon.registry.handler.beans.SimulationResponse;

public class CommonUtil {
    private static final Log log = LogFactory.getLog(CommonUtil.class);
    private static String contextRoot = null;
    private static RegistryService registryService;
    private static SimulationService simulationService;

    public static synchronized void setRegistryService(RegistryService service) {
        if (registryService == null) {
            registryService = service;
        }
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static void simulateRegistryOperation(Registry rootRegistry, SimulationRequest simulationRequest) throws Exception {
        String operation = simulationRequest.getOperation();
        if (operation == null) {
            return;
        }
        if (operation.toLowerCase().equals("get")) {
            String path = simulationRequest.getPath();
            if (CommonUtil.isInvalidateValue(path)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.get(path);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("resourceexists")) {
            String path = simulationRequest.getPath();
            if (CommonUtil.isInvalidateValue(path)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.resourceExists(path);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("put")) {
            String path = simulationRequest.getPath();
            String resourcePath = simulationRequest.getResourcePath();
            String type = null;
            String[] params = simulationRequest.getParameters();
            if (params != null && params.length >= 1) {
                type = params[0];
            }
            if (CommonUtil.isInvalidateValue(path) || CommonUtil.isInvalidateValue(type)) {
                return;
            }
            Object resource = !CommonUtil.isInvalidateValue(resourcePath) && rootRegistry.resourceExists(resourcePath) ? rootRegistry.get(resourcePath) : (type.toLowerCase().equals("collection") ? rootRegistry.newCollection() : rootRegistry.newResource());
            simulationService.setSimulation(true);
            resource.setMediaType(simulationRequest.getMediaType());
            rootRegistry.put(path, resource);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("delete")) {
            String path = simulationRequest.getPath();
            if (CommonUtil.isInvalidateValue(path)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.delete(path);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("importresource")) {
            String path = simulationRequest.getPath();
            String sourceURL = null;
            String[] params = simulationRequest.getParameters();
            if (params != null && params.length >= 1) {
                sourceURL = params[0];
            }
            if (CommonUtil.isInvalidateValue(path) || CommonUtil.isInvalidateValue(sourceURL)) {
                return;
            }
            simulationService.setSimulation(true);
            Resource resource = rootRegistry.newResource();
            resource.setMediaType(simulationRequest.getMediaType());
            rootRegistry.importResource(path, sourceURL, resource);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("rename")) {
            String path = simulationRequest.getPath();
            String target = null;
            String[] params = simulationRequest.getParameters();
            if (params != null && params.length >= 1) {
                target = params[0];
            }
            if (CommonUtil.isInvalidateValue(path) || CommonUtil.isInvalidateValue(target)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.rename(path, target);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("move")) {
            String path = simulationRequest.getPath();
            String target = null;
            String[] params = simulationRequest.getParameters();
            if (params != null && params.length >= 1) {
                target = params[0];
            }
            if (CommonUtil.isInvalidateValue(path) || CommonUtil.isInvalidateValue(target)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.move(path, target);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("copy")) {
            String path = simulationRequest.getPath();
            String target = null;
            String[] params = simulationRequest.getParameters();
            if (params != null && params.length >= 1) {
                target = params[0];
            }
            if (CommonUtil.isInvalidateValue(path) || CommonUtil.isInvalidateValue(target)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.copy(path, target);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("removelink")) {
            String path = simulationRequest.getPath();
            if (CommonUtil.isInvalidateValue(path)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.removeLink(path);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("createlink")) {
            String path = simulationRequest.getPath();
            String target = null;
            String targetSubPath = null;
            String[] params = simulationRequest.getParameters();
            if (params != null && params.length > 0) {
                target = params[0];
                if (params.length > 1) {
                    targetSubPath = params[1];
                }
            }
            if (CommonUtil.isInvalidateValue(path) || CommonUtil.isInvalidateValue(target)) {
                return;
            }
            simulationService.setSimulation(true);
            if (CommonUtil.isInvalidateValue(targetSubPath)) {
                rootRegistry.createLink(path, target);
            } else {
                rootRegistry.createLink(path, target, targetSubPath);
            }
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("invokeaspect")) {
            String path = simulationRequest.getPath();
            String aspectName = null;
            String action = null;
            String[] params = simulationRequest.getParameters();
            if (params != null && params.length >= 2) {
                aspectName = params[0];
                action = params[1];
            }
            if (CommonUtil.isInvalidateValue(path) || CommonUtil.isInvalidateValue(aspectName) || CommonUtil.isInvalidateValue(action)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.invokeAspect(path, aspectName, action);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("addassociation")) {
            String path = simulationRequest.getPath();
            String target = null;
            String associationType = null;
            String[] params = simulationRequest.getParameters();
            if (params != null && params.length >= 2) {
                target = params[0];
                associationType = params[1];
            }
            if (CommonUtil.isInvalidateValue(path) || CommonUtil.isInvalidateValue(target) || CommonUtil.isInvalidateValue(associationType)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.addAssociation(path, target, associationType);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("removeassociation")) {
            String path = simulationRequest.getPath();
            String target = null;
            String associationType = null;
            String[] params = simulationRequest.getParameters();
            if (params != null && params.length >= 2) {
                target = params[0];
                associationType = params[1];
            }
            if (CommonUtil.isInvalidateValue(path) || CommonUtil.isInvalidateValue(target) || CommonUtil.isInvalidateValue(associationType)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.removeAssociation(path, target, associationType);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("getassociations")) {
            String path = simulationRequest.getPath();
            String associationType = null;
            String[] params = simulationRequest.getParameters();
            if (params != null && params.length >= 1) {
                associationType = params[0];
            }
            if (CommonUtil.isInvalidateValue(path) || CommonUtil.isInvalidateValue(associationType)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.getAssociations(path, associationType);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("getallassociations")) {
            String path = simulationRequest.getPath();
            if (CommonUtil.isInvalidateValue(path)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.getAllAssociations(path);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("createversion")) {
            String path = simulationRequest.getPath();
            if (CommonUtil.isInvalidateValue(path)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.createVersion(path);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("restoreversion")) {
            String path = simulationRequest.getPath();
            if (CommonUtil.isInvalidateValue(path)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.restoreVersion(path);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("getversions")) {
            String path = simulationRequest.getPath();
            if (CommonUtil.isInvalidateValue(path)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.getVersions(path);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("applytag")) {
            String path = simulationRequest.getPath();
            String tag = null;
            String[] params = simulationRequest.getParameters();
            if (params != null && params.length >= 1) {
                tag = params[0];
            }
            if (CommonUtil.isInvalidateValue(path) || CommonUtil.isInvalidateValue(tag)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.applyTag(path, tag);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("removetag")) {
            String path = simulationRequest.getPath();
            String tag = null;
            String[] params = simulationRequest.getParameters();
            if (params != null && params.length >= 1) {
                tag = params[0];
            }
            if (CommonUtil.isInvalidateValue(path) || CommonUtil.isInvalidateValue(tag)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.removeTag(path, tag);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("gettags")) {
            String path = simulationRequest.getPath();
            if (CommonUtil.isInvalidateValue(path)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.getTags(path);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("getresourcepathswithtag")) {
            String tag = null;
            String[] params = simulationRequest.getParameters();
            if (params != null && params.length >= 1) {
                tag = params[0];
            }
            if (CommonUtil.isInvalidateValue(tag)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.getResourcePathsWithTag(tag);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("rateresource")) {
            String path = simulationRequest.getPath();
            int rating = -1;
            String[] params = simulationRequest.getParameters();
            if (params != null && params.length >= 1) {
                try {
                    rating = Integer.parseInt(params[0]);
                }
                catch (NumberFormatException ignored) {
                    return;
                }
            }
            if (CommonUtil.isInvalidateValue(path) || rating == -1) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.rateResource(path, rating);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("getrating")) {
            String path = simulationRequest.getPath();
            String username = null;
            String[] params = simulationRequest.getParameters();
            if (params != null && params.length >= 1) {
                username = params[0];
            }
            if (CommonUtil.isInvalidateValue(path) || CommonUtil.isInvalidateValue(username)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.getRating(path, username);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("getaveragerating")) {
            String path = simulationRequest.getPath();
            if (CommonUtil.isInvalidateValue(path)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.getAverageRating(path);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("addcomment")) {
            String path = simulationRequest.getPath();
            String comment = null;
            String[] params = simulationRequest.getParameters();
            if (params != null && params.length >= 1) {
                comment = params[0];
            }
            if (CommonUtil.isInvalidateValue(path) || CommonUtil.isInvalidateValue(comment)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.addComment(path, new Comment(comment));
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("editcomment")) {
            String path = simulationRequest.getPath();
            String comment = null;
            String[] params = simulationRequest.getParameters();
            if (params != null && params.length >= 1) {
                comment = params[0];
            }
            if (CommonUtil.isInvalidateValue(path) || CommonUtil.isInvalidateValue(comment)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.editComment(path, comment);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("removeComment")) {
            String path = simulationRequest.getPath();
            if (CommonUtil.isInvalidateValue(path)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.removeComment(path);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("getcomments")) {
            String path = simulationRequest.getPath();
            if (CommonUtil.isInvalidateValue(path)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.getComments(path);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("searchcontent")) {
            String keywords = null;
            String[] params = simulationRequest.getParameters();
            if (params != null && params.length >= 1) {
                keywords = params[0];
            }
            if (CommonUtil.isInvalidateValue(keywords)) {
                return;
            }
            simulationService.setSimulation(true);
            rootRegistry.searchContent(keywords);
            simulationService.setSimulation(false);
        } else if (operation.toLowerCase().equals("executequery")) {
            String path = simulationRequest.getPath();
            String queryParams = null;
            String[] params = simulationRequest.getParameters();
            if (params != null && params.length >= 1) {
                queryParams = params[0];
            }
            LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
            if (CommonUtil.isInvalidateValue(queryParams)) {
                return;
            }
            String[] entries = queryParams.split(",");
            if (entries != null) {
                for (String entry : entries) {
                    String[] keyValPair = entry.split(":");
                    if (keyValPair == null || keyValPair.length != 2) continue;
                    paramMap.put(keyValPair[0], keyValPair[1]);
                }
            }
            simulationService.setSimulation(true);
            rootRegistry.executeQuery(path, paramMap);
            simulationService.setSimulation(false);
        } else {
            throw new Exception("Unsupported Registry Operation: " + operation);
        }
    }

    private static boolean isInvalidateValue(String paramValue) {
        return null == paramValue || "".equals(paramValue);
    }

    public static SimulationResponse getSimulationResponse() {
        Map status = simulationService.getSimulationStatus();
        int entryCount = 0;
        HashMap<Integer, HandlerExecutionStatus> executionStatusMap = new HashMap<Integer, HandlerExecutionStatus>();
        if (status != null) {
            for (Map.Entry e : status.entrySet()) {
                if (e.getKey() == null || e.getValue() == null || ((List)e.getValue()).size() <= 0) continue;
                for (String[] v : (List)e.getValue()) {
                    if (v == null || v.length != 2) continue;
                    HandlerExecutionStatus executionStatus = new HandlerExecutionStatus();
                    executionStatus.setHandlerName((String)e.getKey());
                    executionStatus.setExecutionStatus(v[0]);
                    int order = Integer.parseInt(v[1]);
                    executionStatusMap.put(order, executionStatus);
                    if (order <= entryCount) continue;
                    entryCount = order;
                }
            }
        }
        LinkedList<HandlerExecutionStatus> executionStatusList = new LinkedList<HandlerExecutionStatus>();
        int i = 0;
        while (i < entryCount) {
            HandlerExecutionStatus executionStatus;
            if ((executionStatus = (HandlerExecutionStatus)executionStatusMap.get(++i)) == null) continue;
            executionStatusList.add(executionStatus);
        }
        SimulationResponse response = new SimulationResponse();
        response.setStatus(executionStatusList.toArray(new HandlerExecutionStatus[executionStatusList.size()]));
        return response;
    }

    public static boolean updateHandler(Registry configSystemRegistry, String oldName, String payload) throws RegistryException, XMLStreamException {
        if (CommonUtil.isHandlerNameInUse(oldName)) {
            throw new RegistryException("Could not update handler since it is already in use!");
        }
        String newName = null;
        OMElement element = AXIOMUtil.stringToOM((String)payload);
        if (element != null) {
            newName = element.getAttributeValue(new QName("class"));
        }
        if (newName == null || newName.equals("")) {
            return false;
        }
        if (oldName == null || oldName.equals("")) {
            String path = CommonUtil.getContextRoot() + newName;
            if (CommonUtil.handlerExists(configSystemRegistry, newName)) {
                return false;
            }
            ResourceImpl resource = new ResourceImpl();
            resource.setContent((Object)payload);
            try {
                configSystemRegistry.beginTransaction();
                configSystemRegistry.put(path, (Resource)resource);
                CommonUtil.generateHandler(configSystemRegistry, path);
                configSystemRegistry.commitTransaction();
            }
            catch (Exception e) {
                configSystemRegistry.rollbackTransaction();
                throw new RegistryException("Unable to generate handler", (Throwable)e);
            }
            return true;
        }
        if (newName.equals(oldName)) {
            String oldPath = CommonUtil.getContextRoot() + oldName;
            Object resource = CommonUtil.handlerExists(configSystemRegistry, oldName) ? configSystemRegistry.get(oldPath) : new ResourceImpl();
            resource.setContent((Object)payload);
            try {
                configSystemRegistry.beginTransaction();
                CommonUtil.removeHandler(configSystemRegistry, oldName);
                configSystemRegistry.put(oldPath, resource);
                CommonUtil.generateHandler(configSystemRegistry, oldPath);
                configSystemRegistry.commitTransaction();
            }
            catch (Exception e) {
                configSystemRegistry.rollbackTransaction();
                throw new RegistryException("Unable to generate handler", (Throwable)e);
            }
            return true;
        }
        String oldPath = CommonUtil.getContextRoot() + oldName;
        String newPath = CommonUtil.getContextRoot() + newName;
        if (CommonUtil.handlerExists(configSystemRegistry, newName)) {
            return false;
        }
        Object resource = CommonUtil.handlerExists(configSystemRegistry, oldName) ? configSystemRegistry.get(oldPath) : new ResourceImpl();
        resource.setContent((Object)payload);
        try {
            configSystemRegistry.beginTransaction();
            configSystemRegistry.put(newPath, resource);
            CommonUtil.generateHandler(configSystemRegistry, newPath);
            CommonUtil.removeHandler(configSystemRegistry, oldName);
            configSystemRegistry.delete(oldPath);
            configSystemRegistry.commitTransaction();
        }
        catch (Exception e) {
            configSystemRegistry.rollbackTransaction();
            throw new RegistryException("Unable to renew handler", (Throwable)e);
        }
        return true;
    }

    public static boolean addHandler(Registry configSystemRegistry, String payload) throws RegistryException, XMLStreamException {
        OMElement element = AXIOMUtil.stringToOM((String)payload);
        if (element == null) {
            return false;
        }
        String name = element.getAttributeValue(new QName("class"));
        if (CommonUtil.isHandlerNameInUse(name)) {
            throw new RegistryException("The added handler name is already in use!");
        }
        String path = CommonUtil.getContextRoot() + name;
        if (CommonUtil.handlerExists(configSystemRegistry, name)) {
            throw new RegistryException("The added handler name is already in use!");
        }
        ResourceImpl resource = new ResourceImpl();
        resource.setContent((Object)payload);
        try {
            configSystemRegistry.beginTransaction();
            configSystemRegistry.put(path, (Resource)resource);
            CommonUtil.generateHandler(configSystemRegistry, path);
            configSystemRegistry.commitTransaction();
        }
        catch (Exception e) {
            configSystemRegistry.rollbackTransaction();
            throw new RegistryException("Unable to generate handler", (Throwable)e);
        }
        return true;
    }

    public static boolean handlerExists(Registry configSystemRegistry, String name) throws RegistryException {
        return configSystemRegistry.resourceExists(CommonUtil.getContextRoot() + name);
    }

    public static boolean deleteHandler(Registry configSystemRegistry, String name) throws RegistryException, XMLStreamException {
        if (CommonUtil.isHandlerNameInUse(name)) {
            throw new RegistryException("Handler could not be deleted, since it is already in use!");
        }
        String path = CommonUtil.getContextRoot() + name;
        if (configSystemRegistry.resourceExists(path)) {
            try {
                configSystemRegistry.beginTransaction();
                CommonUtil.removeHandler(configSystemRegistry, name);
                configSystemRegistry.delete(path);
                configSystemRegistry.commitTransaction();
            }
            catch (Exception e) {
                configSystemRegistry.rollbackTransaction();
                throw new RegistryException("Unable to remove handler", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    public static String getHandlerConfiguration(Registry configSystemRegistry, String name) throws RegistryException, XMLStreamException {
        String path = CommonUtil.getContextRoot() + name;
        if (CommonUtil.handlerExists(configSystemRegistry, name)) {
            Resource resource = configSystemRegistry.get(path);
            return RegistryUtils.decodeBytes((byte[])((byte[])resource.getContent()));
        }
        return null;
    }

    public static String[] getHandlerList(Registry configSystemRegistry) throws RegistryException {
        Collection collection;
        try {
            collection = (Collection)configSystemRegistry.get(CommonUtil.getContextRoot());
        }
        catch (Exception e) {
            return null;
        }
        if (collection == null) {
            CollectionImpl handlerCollection = new CollectionImpl();
            configSystemRegistry.put(CommonUtil.getContextRoot(), (Resource)handlerCollection);
            return null;
        }
        if (collection.getChildCount() == 0) {
            return null;
        }
        String[] childrenList = collection.getChildren();
        String[] handlerNameList = new String[collection.getChildCount()];
        for (int i = 0; i < childrenList.length; ++i) {
            String path = childrenList[i];
            handlerNameList[i] = path.substring(path.lastIndexOf("/") + 1);
        }
        return handlerNameList;
    }

    public static String getContextRoot() {
        if (contextRoot == null) {
            return "/repository/components/org.wso2.carbon.governance/handlers/";
        }
        return contextRoot;
    }

    public static void setContextRoot(String contextRoot) {
        if (!contextRoot.endsWith("/")) {
            contextRoot = contextRoot + "/";
        }
        CommonUtil.contextRoot = contextRoot;
    }

    public static boolean generateHandler(Registry configSystemRegistry, String resourceFullPath) throws RegistryException, XMLStreamException {
        RegistryContext registryContext = configSystemRegistry.getRegistryContext();
        if (registryContext == null) {
            return false;
        }
        Resource resource = configSystemRegistry.get(resourceFullPath);
        if (resource != null) {
            OMElement handler;
            String content = null;
            if (resource.getContent() != null) {
                content = RegistryUtils.decodeBytes((byte[])((byte[])resource.getContent()));
            }
            if (content != null && (handler = AXIOMUtil.stringToOM(content)) != null) {
                OMElement dummy = OMAbstractFactory.getOMFactory().createOMElement("dummy", null);
                dummy.addChild((OMNode)handler);
                try {
                    configSystemRegistry.beginTransaction();
                    boolean status = RegistryConfigurationProcessor.updateHandler((OMElement)dummy, (RegistryContext)configSystemRegistry.getRegistryContext(), (String)"user");
                    configSystemRegistry.commitTransaction();
                    return status;
                }
                catch (Exception e) {
                    configSystemRegistry.rollbackTransaction();
                    throw new RegistryException("Unable to add handler", (Throwable)e);
                }
            }
        }
        return false;
    }

    public static boolean removeHandler(Registry configSystemRegistry, String handlerName) throws RegistryException, XMLStreamException {
        String handlerConfiguration = CommonUtil.getHandlerConfiguration(configSystemRegistry, handlerName);
        if (handlerConfiguration != null) {
            OMElement element = AXIOMUtil.stringToOM((String)handlerConfiguration);
            try {
                configSystemRegistry.beginTransaction();
                RegistryConfigurationProcessor.HandlerDefinitionObject handlerDefinitionObject = new RegistryConfigurationProcessor.HandlerDefinitionObject(null, element).invoke();
                String[] methods = handlerDefinitionObject.getMethods();
                Filter filter = handlerDefinitionObject.getFilter();
                Handler handler = handlerDefinitionObject.getHandler();
                if (handlerDefinitionObject.getTenantId() != -1) {
                    CurrentSession.setCallerTenantId((int)handlerDefinitionObject.getTenantId());
                    configSystemRegistry.getRegistryContext().getHandlerManager().removeHandler(methods, filter, handler, "user");
                    CurrentSession.removeCallerTenantId();
                } else {
                    configSystemRegistry.getRegistryContext().getHandlerManager().removeHandler(methods, filter, handler, "user");
                }
                configSystemRegistry.commitTransaction();
                return true;
            }
            catch (Exception e) {
                try {
                    configSystemRegistry.rollbackTransaction();
                    throw e;
                }
                catch (Exception e2) {
                    if (e2 instanceof RegistryException) {
                        throw (RegistryException)e2;
                    }
                    if (e2 instanceof XMLStreamException) {
                        throw (XMLStreamException)e2;
                    }
                    throw new RegistryException("Unable to build handler configuration", (Throwable)e2);
                }
            }
        }
        return false;
    }

    public static boolean isHandlerNameInUse(String name) throws RegistryException, XMLStreamException {
        return false;
    }

    public static boolean addDefaultHandlersIfNotAvailable(Registry configSystemRegistry) throws RegistryException, FileNotFoundException, XMLStreamException {
        if (!configSystemRegistry.resourceExists("/repository/components/org.wso2.carbon.governance/handlers/")) {
            CollectionImpl handlerConfigurationCollection = new CollectionImpl();
            String description = "Handler configurations are stored here.";
            handlerConfigurationCollection.setDescription(description);
            configSystemRegistry.put("/repository/components/org.wso2.carbon.governance/handlers/", (Resource)handlerConfigurationCollection);
        } else {
            Resource handlerRoot = configSystemRegistry.get(CommonUtil.getContextRoot());
            if (!(handlerRoot instanceof Collection)) {
                String msg = "Failed to continue as the handler configuration root: " + CommonUtil.getContextRoot() + " is not a collection.";
                log.error((Object)msg);
                throw new RegistryException(msg);
            }
            Collection handlerRootCol = (Collection)handlerRoot;
            String[] handlerConfigPaths = handlerRootCol.getChildren();
            if (handlerConfigPaths != null) {
                for (String handlerConfigPath : handlerConfigPaths) {
                    CommonUtil.generateHandler(configSystemRegistry, handlerConfigPath);
                }
            }
        }
        return true;
    }

    public static SimulationService getSimulationService() {
        return simulationService;
    }

    public static void setSimulationService(SimulationService simulationService) {
        CommonUtil.simulationService = simulationService;
    }

    public static HandlerConfigurationBean deserializeHandlerConfiguration(OMElement configurationElement) {
        if (configurationElement == null || !"handler".equals(configurationElement.getLocalName())) {
            return null;
        }
        HandlerConfigurationBean handlerConfigurationBean = new HandlerConfigurationBean();
        handlerConfigurationBean.setHandlerClass(configurationElement.getAttributeValue(new QName("class")));
        handlerConfigurationBean.setTenant(configurationElement.getAttributeValue(new QName("tenant")));
        String methodsAttribute = configurationElement.getAttributeValue(new QName("methods"));
        if (methodsAttribute != null && methodsAttribute.length() != 0) {
            handlerConfigurationBean.setMethods(methodsAttribute.split(","));
        }
        Iterator handlerProps = configurationElement.getChildrenWithName(new QName("property"));
        while (handlerProps.hasNext()) {
            OMElement propElement = (OMElement)handlerProps.next();
            String propName = propElement.getAttributeValue(new QName("name"));
            String propType = propElement.getAttributeValue(new QName("type"));
            if (propType != null && "xml".equals(propType)) {
                handlerConfigurationBean.getXmlProperties().put(propName, propElement);
            } else {
                handlerConfigurationBean.getNonXmlProperties().put(propName, propElement.getText());
            }
            handlerConfigurationBean.getPropertyList().add(propName);
        }
        FilterConfigurationBean filterConfigurationBean = new FilterConfigurationBean();
        OMElement filterElement = configurationElement.getFirstChildWithName(new QName("filter"));
        filterConfigurationBean.setFilterClass(filterElement.getAttributeValue(new QName("class")));
        Iterator filterProps = filterElement.getChildrenWithName(new QName("property"));
        while (filterProps.hasNext()) {
            OMElement propElement = (OMElement)filterProps.next();
            String propName = propElement.getAttributeValue(new QName("name"));
            String propType = propElement.getAttributeValue(new QName("type"));
            if (propType != null && "xml".equals(propType)) {
                filterConfigurationBean.getXmlProperties().put(propName, propElement);
            } else {
                filterConfigurationBean.getNonXmlProperties().put(propName, propElement.getText());
            }
            filterConfigurationBean.getPropertyList().add(propName);
        }
        handlerConfigurationBean.setFilter(filterConfigurationBean);
        return handlerConfigurationBean;
    }

    public static OMElement serializeHandlerConfiguration(HandlerConfigurationBean bean) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement handler = factory.createOMElement("handler", null);
        handler.addAttribute(factory.createOMAttribute("class", null, bean.getHandlerClass()));
        if (bean.getTenant() != null) {
            handler.addAttribute(factory.createOMAttribute("tenant", null, bean.getTenant()));
        }
        StringBuilder sb = new StringBuilder();
        for (String method : bean.getMethods()) {
            if (method == null || method.length() <= 0) continue;
            sb.append(method).append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            handler.addAttribute(factory.createOMAttribute("methods", null, sb.toString()));
        }
        for (String property : bean.getPropertyList()) {
            OMElement temp = factory.createOMElement("property", null);
            temp.addAttribute(factory.createOMAttribute("name", null, property));
            OMElement xmlProperty = bean.getXmlProperties().get(property);
            if (xmlProperty != null) {
                handler.addChild((OMNode)xmlProperty);
                continue;
            }
            String nonXMLProperty = bean.getNonXmlProperties().get(property);
            if (nonXMLProperty == null) continue;
            temp.setText(nonXMLProperty);
            handler.addChild((OMNode)temp);
        }
        OMElement filter = factory.createOMElement("filter", null);
        filter.addAttribute(factory.createOMAttribute("class", null, bean.getFilter().getFilterClass()));
        for (String property : bean.getFilter().getPropertyList()) {
            OMElement temp = factory.createOMElement("property", null);
            temp.addAttribute(factory.createOMAttribute("name", null, property));
            OMElement xmlProperty = bean.getFilter().getXmlProperties().get(property);
            if (xmlProperty != null) {
                temp.addAttribute(factory.createOMAttribute("type", null, "xml"));
                temp.addChild((OMNode)xmlProperty);
                filter.addChild((OMNode)temp);
                continue;
            }
            String nonXMLProperty = bean.getFilter().getNonXmlProperties().get(property);
            if (nonXMLProperty == null) continue;
            temp.setText(nonXMLProperty);
            filter.addChild((OMNode)temp);
        }
        handler.addChild((OMNode)filter);
        return handler;
    }
}

