/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.handler.ui.clients;

import java.util.LinkedList;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.MediaTypesUtils;
import org.wso2.carbon.registry.handler.stub.HandlerManagementServiceStub;
import org.wso2.carbon.registry.handler.stub.beans.xsd.SimulationRequest;
import org.wso2.carbon.registry.handler.stub.beans.xsd.SimulationResponse;
import org.wso2.carbon.ui.CarbonUIUtil;

public class HandlerManagementServiceClient {
    private static final Log log = LogFactory.getLog(HandlerManagementServiceClient.class);
    private HandlerManagementServiceStub stub;

    public HandlerManagementServiceClient(String cookie, ServletConfig config, HttpSession session) throws RegistryException {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String epr = backendServerURL + "HandlerManagementService";
        try {
            this.stub = new HandlerManagementServiceStub(configContext, epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate handler management service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public String[] getHandlerList(HttpServletRequest request) throws Exception {
        String[] output;
        try {
            output = this.stub.getHandlerList();
        }
        catch (Exception e) {
            if (e instanceof RegistryException) {
                return new String[0];
            }
            throw e;
        }
        return output;
    }

    public String getHandlerConfiguration(HttpServletRequest request) throws Exception {
        String output;
        String handlerName = request.getParameter("handlerName");
        try {
            output = this.stub.getHandlerConfiguration(handlerName);
        }
        catch (Exception e) {
            if (e instanceof RegistryException) {
                return "";
            }
            throw e;
        }
        return output;
    }

    public boolean newHandler(HttpServletRequest request) throws Exception {
        boolean output;
        String payload = request.getParameter("payload");
        try {
            output = this.stub.createHandler(payload);
        }
        catch (Exception e) {
            if (e instanceof RegistryException) {
                return false;
            }
            throw e;
        }
        return output;
    }

    public boolean updateHandler(HttpServletRequest request) throws Exception {
        boolean output;
        String handlerName = request.getParameter("handlerName");
        if (handlerName == null) {
            handlerName = "";
        }
        String payload = request.getParameter("payload");
        try {
            output = this.stub.updateHandler(handlerName, payload);
        }
        catch (Exception e) {
            if (e instanceof RegistryException) {
                return false;
            }
            throw e;
        }
        return output;
    }

    public boolean deleteHandler(HttpServletRequest request) throws Exception {
        boolean output;
        String handlerName = request.getParameter("handlerName");
        try {
            output = this.stub.deleteHandler(handlerName);
        }
        catch (Exception e) {
            if (e instanceof RegistryException) {
                return false;
            }
            throw e;
        }
        return output;
    }

    public SimulationResponse simulate(HttpServletRequest request) throws Exception {
        SimulationResponse output;
        SimulationRequest simulationRequest = new SimulationRequest();
        simulationRequest.setMediaType(MediaTypesUtils.getMimeTypeFromHumanReadableMediaType((String)request.getParameter("mediaType")));
        simulationRequest.setOperation(request.getParameter("operation"));
        simulationRequest.setPath(request.getParameter("path"));
        simulationRequest.setResourcePath(request.getParameter("resourcePath"));
        LinkedList<String> parameters = new LinkedList<String>();
        int i = 1;
        String temp = request.getParameter("param" + i);
        while (temp != null) {
            parameters.add(temp);
            temp = request.getParameter("param" + ++i);
        }
        if (parameters.size() > 0) {
            simulationRequest.setParameters(parameters.toArray(new String[parameters.size()]));
        }
        try {
            output = this.stub.simulate(simulationRequest);
        }
        catch (Exception e) {
            if (e instanceof RegistryException) {
                return new SimulationResponse();
            }
            throw e;
        }
        return output;
    }
}

