/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.handler.listener;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.core.services.callback.LoginEvent;
import org.wso2.carbon.core.services.callback.LoginListener;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.handler.util.CommonUtil;

public class HandlerLoader
implements LoginListener {
    private static Log log = LogFactory.getLog(HandlerLoader.class);
    private List<Integer> initializedTenants = new LinkedList<Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLogin(Registry configSystemRegistry, LoginEvent loginEvent) {
        try {
            if (this.initializedTenants.contains(loginEvent.getTenantId())) {
                return;
            }
            this.initializedTenants.add(loginEvent.getTenantId());
            SuperTenantCarbonContext.startTenantFlow();
            try {
                SuperTenantCarbonContext.getCurrentContext().setTenantId(loginEvent.getTenantId());
                SuperTenantCarbonContext.getCurrentContext().setUsername(loginEvent.getUsername());
                CommonUtil.addDefaultHandlersIfNotAvailable(configSystemRegistry);
            }
            finally {
                SuperTenantCarbonContext.endTenantFlow();
            }
        }
        catch (Exception e) {
            String msg = "Error in adding the default handlers";
            log.error((Object)msg, (Throwable)e);
        }
    }
}

