/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.internal;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.embed.Embedder;
import org.wso2.carbon.registry.extensions.handlers.scm.ExternalContentHandler;

public class SCMUpdateTask
implements Runnable {
    private static final Log log = LogFactory.getLog(SCMUpdateTask.class);
    private String checkOutURL;
    private String checkInURL;
    private String username;
    private String password;
    private File workingDir;
    private boolean readOnly;
    private ExternalContentHandler handler;

    public SCMUpdateTask(File workingDir, String checkOutURL, String checkInURL, boolean readOnly, ExternalContentHandler handler, String username, String password) {
        this.workingDir = workingDir;
        this.checkOutURL = checkOutURL;
        this.checkInURL = checkInURL;
        this.readOnly = readOnly;
        this.handler = handler;
        this.username = username;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Embedder plexus = null;
        try {
            plexus = new Embedder();
            plexus.start();
            this.handler.setBusy(true);
            ScmManager scmManager = (ScmManager)plexus.lookup(ScmManager.ROLE);
            ScmRepository scmRepository = scmManager.makeScmRepository(this.checkOutURL);
            if (this.username != null && this.password != null) {
                scmRepository.getProviderRepository().setUser(this.username);
                scmRepository.getProviderRepository().setPassword(this.password);
            }
            StatusScmResult status = scmManager.status(scmRepository, new ScmFileSet(this.workingDir));
            List changedFiles = status.getChangedFiles();
            LinkedList<File> toDelete = new LinkedList<File>();
            for (ScmFile file : changedFiles) {
                if (file.getStatus() != ScmFileStatus.MISSING) continue;
                toDelete.add(new File(file.getPath()));
            }
            if (this.workingDir.list() == null) {
                log.error((Object)("A directory was not found in the given path: " + this.workingDir.getAbsolutePath()));
                return;
            }
            if (this.workingDir.list().length == 0) {
                scmManager.checkOut(scmRepository, new ScmFileSet(this.workingDir));
            } else {
                scmManager.update(scmRepository, new ScmFileSet(this.workingDir));
            }
            status = scmManager.status(scmRepository, new ScmFileSet(this.workingDir));
            changedFiles = status.getChangedFiles();
            LinkedList<File> toAdd = new LinkedList<File>();
            LinkedList<File> conflicts = new LinkedList<File>();
            LinkedList<File> toCheckIn = new LinkedList<File>();
            for (ScmFile scmFile : changedFiles) {
                if (scmFile.getStatus() == ScmFileStatus.UNKNOWN) {
                    File fileToAdd = new File(scmFile.getPath());
                    toAdd.add(fileToAdd);
                    toCheckIn.add(fileToAdd);
                    continue;
                }
                if (scmFile.getStatus() == ScmFileStatus.CONFLICT) {
                    conflicts.add(new File(scmFile.getPath()));
                    continue;
                }
                if (scmFile.getStatus() != ScmFileStatus.MODIFIED && scmFile.getStatus() != ScmFileStatus.ADDED && scmFile.getStatus() != ScmFileStatus.DELETED) continue;
                toCheckIn.add(new File(scmFile.getPath()));
            }
            if (conflicts.size() > 0) {
                for (File file : conflicts) {
                    try {
                        log.warn((Object)("Resolving conflict: " + file.getAbsolutePath()));
                        FileUtils.forceDelete((File)file);
                    }
                    catch (IOException e) {
                        log.error((Object)"Unable to resolve conflict", (Throwable)e);
                    }
                }
                scmManager.update(scmRepository, new ScmFileSet(this.workingDir, conflicts));
            }
            if (toDelete.size() > 0) {
                for (File file : toDelete) {
                    try {
                        if (file.exists()) {
                            FileUtils.forceDelete((File)file);
                        }
                        toCheckIn.add(file);
                    }
                    catch (IOException e) {
                        log.error((Object)"Unable to remove file to delete", (Throwable)e);
                    }
                }
                scmManager.update(scmRepository, new ScmFileSet(this.workingDir, conflicts));
            }
            if (!this.readOnly) {
                if (this.checkInURL == null) {
                    this.makeChanges(scmManager, scmRepository, toCheckIn, toDelete, toAdd);
                } else {
                    scmRepository = scmManager.makeScmRepository(this.checkInURL);
                    this.makeChanges(scmManager, scmRepository, toCheckIn, toDelete, toAdd);
                }
            }
        }
        catch (PlexusContainerException e) {
            log.error((Object)"Unable to start Plexus Container", (Throwable)e);
        }
        catch (ComponentLookupException e) {
            log.error((Object)"Unable to obtain instance of SCM Manager", (Throwable)e);
        }
        catch (ScmRepositoryException e) {
            log.error((Object)"Unable to create an instance of a SCM repository", (Throwable)e);
        }
        catch (NoSuchScmProviderException e) {
            log.error((Object)"A provider was not found for the specified SCM URL", (Throwable)e);
        }
        catch (ScmException e) {
            log.error((Object)"The SCM operation failed", (Throwable)e);
        }
        finally {
            this.handler.setBusy(false);
        }
        try {
            plexus.stop();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void makeChanges(ScmManager scmManager, ScmRepository scmRepository, List<File> toCheckIn, List<File> toDelete, List<File> toAdd) throws ScmException {
        if (toAdd.size() > 0) {
            scmManager.add(scmRepository, new ScmFileSet(this.workingDir, toAdd), "");
        }
        if (toDelete.size() > 0) {
            scmManager.remove(scmRepository, new ScmFileSet(this.workingDir, toDelete), "");
        }
        if (toCheckIn.size() > 0) {
            scmManager.checkIn(scmRepository, new ScmFileSet(this.workingDir, toCheckIn), "");
        }
    }
}

