/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.Filter;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.URLMatcher;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.extensions.handlers.scm.ExternalContentHandler;
import org.wso2.carbon.registry.extensions.internal.SCMUpdateTask;
import org.wso2.carbon.utils.CarbonUtils;

public class RegistrySCMServiceComponent {
    private static Log log = LogFactory.getLog(RegistrySCMServiceComponent.class);
    private static final int DEFAULT_UPDATE_FREQUENCY = 60;

    protected void activate(ComponentContext context) {
        log.debug((Object)"Registry SCM component is activated");
    }

    protected void deactivate(ComponentContext context) {
        log.debug((Object)"Registry SCM component is deactivated");
    }

    protected void setRegistryService(RegistryService registryService) {
        try {
            this.registerConnections(registryService);
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to register connections", (Throwable)e);
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
    }

    private void registerConnections(RegistryService registryService) throws RegistryException {
        block9: {
            File registryXML;
            String configPath = CarbonUtils.getRegistryXMLPath();
            if (configPath != null && (registryXML = new File(configPath)).exists()) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(registryXML);
                    StAXOMBuilder builder = new StAXOMBuilder((InputStream)fileInputStream);
                    OMElement configElement = builder.getDocumentElement();
                    OMElement scm = configElement.getFirstChildWithName(new QName("scm"));
                    if (scm == null) break block9;
                    ScheduledExecutorService executorService = Executors.newScheduledThreadPool(10);
                    Iterator connections = scm.getChildrenWithName(new QName("connection"));
                    while (connections.hasNext()) {
                        OMElement connection = (OMElement)connections.next();
                        String checkOutURL = connection.getAttributeValue(new QName("checkOutURL"));
                        boolean readOnly = !Boolean.toString(false).equalsIgnoreCase(connection.getAttributeValue(new QName("readOnly")));
                        String checkInURL = connection.getAttributeValue(new QName("checkInURL"));
                        String workingDir = connection.getAttributeValue(new QName("workingDir"));
                        String mountPoint = connection.getAttributeValue(new QName("mountPoint"));
                        String username = connection.getAttributeValue(new QName("username"));
                        String password = connection.getAttributeValue(new QName("password"));
                        int updateFrequency = 60;
                        try {
                            updateFrequency = Integer.parseInt(connection.getAttributeValue(new QName("updateFrequency")));
                        }
                        catch (NumberFormatException ignore) {
                            // empty catch block
                        }
                        UserRegistry registry = registryService.getRegistry("wso2.system.user");
                        File directory = new File(workingDir);
                        if (!directory.exists() && !directory.isDirectory()) {
                            log.error((Object)("A valid directory was not found in path: " + workingDir));
                            continue;
                        }
                        String filePath = directory.getAbsolutePath();
                        if (!registry.resourceExists(mountPoint)) {
                            Collection collection = registry.newCollection();
                            collection.setProperty("registry.nonrecursive", "true");
                            registry.put(mountPoint, (Resource)collection);
                        }
                        this.loadRegistryResources((Registry)registry, directory, filePath, mountPoint);
                        ExternalContentHandler externalContentHandler = new ExternalContentHandler();
                        externalContentHandler.setFilePath(filePath);
                        externalContentHandler.setMountPath(mountPoint);
                        URLMatcher urlMatcher = new URLMatcher();
                        urlMatcher.setPattern(Pattern.quote(mountPoint) + "($|" + "/" + ".*|" + ";" + ".*)");
                        RegistryContext registryContext = registry.getRegistryContext();
                        registryContext.registerNoCachePath(mountPoint);
                        registryContext.getHandlerManager().addHandler(null, (Filter)urlMatcher, (Handler)externalContentHandler);
                        executorService.scheduleWithFixedDelay(new SCMUpdateTask(directory, checkOutURL, checkInURL, readOnly, externalContentHandler, username, password), 0L, updateFrequency, TimeUnit.MINUTES);
                    }
                }
                catch (XMLStreamException e) {
                    log.error((Object)"Unable to parse registry.xml", (Throwable)e);
                }
                catch (IOException e) {
                    log.error((Object)"Unable to read registry.xml", (Throwable)e);
                }
            }
        }
    }

    private void loadRegistryResources(Registry registry, File directory, String workingDir, String mountPoint) throws RegistryException {
        File[] files = directory.listFiles((FileFilter)new AndFileFilter(HiddenFileFilter.VISIBLE, (IOFileFilter)new OrFileFilter(DirectoryFileFilter.INSTANCE, FileFileFilter.FILE)));
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.loadRegistryResources(registry, file, workingDir, mountPoint);
                continue;
            }
            String path = mountPoint + file.getAbsolutePath().substring(workingDir.length()).replace("\\", "/");
            if (registry.resourceExists(path)) continue;
            registry.put(path, registry.newResource());
        }
    }
}

