/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.statistics.StatisticsCollector;
import org.wso2.carbon.registry.extensions.jmx.Activities;
import org.wso2.carbon.registry.extensions.jmx.ActivitiesMBean;
import org.wso2.carbon.registry.extensions.jmx.Events;
import org.wso2.carbon.registry.extensions.jmx.InvocationStatistics;
import org.wso2.carbon.registry.extensions.jmx.Properties;
import org.wso2.carbon.registry.extensions.jmx.PropertiesMBean;
import org.wso2.carbon.registry.extensions.jmx.Subscriptions;
import org.wso2.carbon.utils.CarbonUtils;

public class RegistryJMXServiceComponent {
    private static Log log = LogFactory.getLog(RegistryJMXServiceComponent.class);
    private boolean isJMXEnabled = false;
    private Map<String, Boolean> jmxServices = new HashMap<String, Boolean>();
    private Stack<ServiceRegistration> serviceRegistrations = new Stack();
    private Stack<ObjectName> mBeans = new Stack();
    private RegistryService registryService;

    protected void activate(ComponentContext context) {
        if (this.isJMXEnabled()) {
            try {
                this.registerMBean(context, new InvocationStatistics(), StatisticsCollector.class.getName());
                this.registerMBean(context, new Subscriptions(), Subscriptions.class.getName());
                this.registerMBean(context, new Activities((Registry)this.registryService.getRegistry("wso2.system.user")), ActivitiesMBean.class.getName());
                this.registerMBean(context, new Properties((Registry)this.registryService.getRegistry("wso2.system.user")), PropertiesMBean.class.getName());
                this.registerMBean(context, new Events(), Events.class.getName());
            }
            catch (JMException e) {
                log.error((Object)"Unable to register JMX extensions", (Throwable)e);
            }
            catch (RegistryException e) {
                log.error((Object)"Unable to obtain registry instance", (Throwable)e);
            }
        }
        log.debug((Object)"Registry JMX component is activated");
    }

    private void registerMBean(ComponentContext context, Object object, String serviceClass) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        String simpleName = object.getClass().getSimpleName();
        if (this.jmxServices.get(simpleName.toLowerCase()) != Boolean.TRUE) {
            return;
        }
        this.mBeans.push(new ObjectName("org.wso2.carbon:Type=Registry,ConnectorName=" + simpleName));
        ManagementFactory.getPlatformMBeanServer().registerMBean(object, this.mBeans.peek());
        this.serviceRegistrations.push(context.getBundleContext().registerService(serviceClass, object, null));
    }

    protected void deactivate(ComponentContext context) {
        while (!this.mBeans.empty()) {
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.mBeans.pop());
            }
            catch (JMException e) {
                log.error((Object)"Unable to un-register JMX extensions", (Throwable)e);
            }
        }
        while (!this.serviceRegistrations.empty()) {
            this.serviceRegistrations.pop().unregister();
        }
        log.debug((Object)"Registry JMX component is deactivated");
    }

    protected void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.registryService = null;
    }

    private boolean isJMXEnabled() {
        File registryXML;
        if (this.isJMXEnabled) {
            return true;
        }
        String configPath = CarbonUtils.getRegistryXMLPath();
        if (configPath != null && (registryXML = new File(configPath)).exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(registryXML);
                StAXOMBuilder builder = new StAXOMBuilder((InputStream)fileInputStream);
                OMElement configElement = builder.getDocumentElement();
                OMElement jmx = configElement.getFirstChildWithName(new QName("jmx"));
                if (jmx != null) {
                    this.isJMXEnabled = Boolean.toString(true).equalsIgnoreCase(jmx.getAttributeValue(new QName("enabled")));
                    Iterator services = jmx.getChildrenWithName(new QName("service"));
                    while (services.hasNext()) {
                        OMElement service = (OMElement)services.next();
                        this.jmxServices.put(service.getAttributeValue(new QName("name")).toLowerCase(), Boolean.toString(true).equalsIgnoreCase(service.getAttributeValue(new QName("enabled"))));
                    }
                }
                return this.isJMXEnabled;
            }
            catch (XMLStreamException e) {
                log.error((Object)"Unable to parse registry.xml", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"Unable to read registry.xml", (Throwable)e);
            }
        }
        return false;
    }
}

