/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers.utils;

import com.ibm.wsdl.util.xml.DOM2Writer;
import com.ibm.wsdl.xml.WSDLReaderImpl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.EndpointUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.ExWSDLReaderImpl;
import org.wso2.carbon.registry.extensions.handlers.utils.SchemaProcessor;
import org.wso2.carbon.registry.extensions.handlers.utils.WSDLInfo;
import org.wso2.carbon.registry.extensions.handlers.utils.WSDLUtils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;
import org.wso2.carbon.registry.extensions.utils.WSDLUtil;
import org.wso2.carbon.registry.extensions.utils.WSDLValidationInfo;
import org.xml.sax.InputSource;

public class WSDLProcessor {
    private Registry registry;
    private Registry systemRegistry;
    private Definition originalDefinition;
    private List<Association> associations;
    private SchemaProcessor schemaProcessor;
    private int i;
    private String resourceName;
    public static final String IMPORT_TAG = "import";
    public static final String INCLUDE_TAG = "include";
    private static final String SAMPLE_BASE_URL = "http://this.wsdl.needs/a/valid/url/to/proceed.wsdl";
    private static String commonWSDLLocation;
    private static String commonSchemaLocation;
    private static String commonPolicyLocation;
    private List<String> visitedWSDLs;
    private List<String> processedWSDLs;
    private Map<String, WSDLInfo> wsdls;
    private WSDLValidationInfo wsdlValidationInfo = null;
    private WSDLValidationInfo wsiValidationInfo = null;
    private boolean hasWSDLImports = false;
    private static Log log;
    private static InheritableThreadLocal<Set<String>> importedWSDLs;
    private boolean createService = true;

    public static synchronized void loadImportedWSDLMap() {
        importedWSDLs.get();
    }

    public static synchronized void clearImportedWSDLMap() {
        importedWSDLs.remove();
    }

    public boolean getCreateService() {
        return this.createService;
    }

    public void setCreateService(boolean createService) {
        this.createService = createService;
    }

    public WSDLProcessor(RequestContext requestContext) {
        this.registry = requestContext.getRegistry();
        try {
            this.systemRegistry = CommonUtil.getUnchrootedSystemRegistry(requestContext);
            if (!this.systemRegistry.resourceExists(this.getChrootedSchemaLocation(requestContext.getRegistryContext()))) {
                this.systemRegistry.put(this.getChrootedSchemaLocation(requestContext.getRegistryContext()), (Resource)this.systemRegistry.newCollection());
            }
            if (!this.systemRegistry.resourceExists(WSDLProcessor.getChrootedWSDLLocation(requestContext.getRegistryContext()))) {
                this.systemRegistry.put(WSDLProcessor.getChrootedWSDLLocation(requestContext.getRegistryContext()), (Resource)this.systemRegistry.newCollection());
            }
        }
        catch (RegistryException ignore) {
            this.systemRegistry = null;
        }
        this.i = 0;
        this.associations = new ArrayList<Association>();
        this.visitedWSDLs = new ArrayList<String>();
        this.processedWSDLs = new ArrayList<String>();
        this.schemaProcessor = this.buildSchemaProcessor(requestContext, null);
        this.wsdls = new LinkedHashMap<String, WSDLInfo>();
        this.resourceName = "";
    }

    public WSDLProcessor(RequestContext requestContext, boolean useOriginalSchema) {
        this(requestContext);
        this.schemaProcessor = this.buildSchemaProcessor(requestContext, null, useOriginalSchema);
    }

    public static void setCommonWSDLLocation(String commonWSDLLocation) {
        WSDLProcessor.commonWSDLLocation = commonWSDLLocation;
    }

    public static void setCommonSchemaLocation(String commonSchemaLocation) {
        WSDLProcessor.commonSchemaLocation = commonSchemaLocation;
    }

    public static void setCommonPolicyLocation(String commonPolicyLocation) {
        WSDLProcessor.commonPolicyLocation = commonPolicyLocation;
    }

    public static String getChrootedWSDLLocation(RegistryContext registryContext) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)("/_system/governance" + commonWSDLLocation));
    }

    private String getChrootedSchemaLocation(RegistryContext registryContext) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)("/_system/governance" + commonSchemaLocation));
    }

    private String getChrootedPolicyLocation(RegistryContext registryContext) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)("/_system/governance" + commonPolicyLocation));
    }

    private String getChrootedServiceLocation(Registry registry, RegistryContext registryContext) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)registry.getRegistryContext().getServicePath());
    }

    public String addWSDLToRegistry(RequestContext context, String wsdlURL, Resource metadata, boolean isPut, boolean addService, boolean skipValidation) throws RegistryException {
        String masterWSDLPath;
        boolean evaluateExports = true;
        boolean isDefaultEnvironment = true;
        String currentWsdlLocation = null;
        String currentSchemaLocation = null;
        String currentEndpointLocation = null;
        String currentEnvironment = null;
        String masterVersion = null;
        ArrayList<String> dependeinciesList = new ArrayList<String>();
        String resourcePath = context.getResourcePath().getPath();
        this.resourceName = resourcePath.substring(resourcePath.lastIndexOf("/") + 1);
        RegistryContext registryContext = context.getRegistryContext();
        this.evaluateWSDLsToDefinitions(wsdlURL, context, evaluateExports, false, isPut, skipValidation);
        String wsdlPath = "";
        for (WSDLInfo wsdlInfo : this.wsdls.values()) {
            Definition wsdlDefinition = wsdlInfo.getWSDLDefinition();
            if (wsdlDefinition == null) continue;
            Types types = wsdlDefinition.getTypes();
            this.schemaProcessor.evaluateSchemas(types, wsdlDefinition.getDocumentBaseURI(), evaluateExports, wsdlInfo.getSchemaDependencies());
            String wsdlName = wsdlInfo.getProposedRegistryURL();
            int index = wsdlName.lastIndexOf("/");
            String wsdlResourceName = wsdlName.substring(index + 1);
            wsdlPath = (WSDLProcessor.getChrootedWSDLLocation(registryContext) + CommonUtil.derivePathFragmentFromNamespace(wsdlDefinition.getTargetNamespace())).replace("//", "/");
            wsdlPath = wsdlPath + wsdlResourceName;
            if (!resourcePath.contains(wsdlResourceName)) {
                wsdlInfo.setProposedRegistryURL(wsdlPath);
                continue;
            }
            if (!resourcePath.equals("/" + wsdlName) & !resourcePath.contains(commonWSDLLocation) & this.registry.resourceExists(resourcePath)) {
                Association[] associations;
                if (currentWsdlLocation == null) {
                    currentEnvironment = resourcePath.substring(0, resourcePath.indexOf(CommonUtil.derivePathFragmentFromNamespace(wsdlDefinition.getTargetNamespace()).replace("//", "/")));
                    String[] pathFragments = commonWSDLLocation.split("/");
                    String wsdlLocation = commonWSDLLocation;
                    String schemaLocation = commonSchemaLocation;
                    String policyLocation = commonPolicyLocation;
                    String endpointLocation = EndpointUtils.getEndpointLocation();
                    for (String pathFragment : pathFragments) {
                        if ((wsdlLocation = wsdlLocation.replace(pathFragment, "")).startsWith("/")) {
                            wsdlLocation = wsdlLocation.replaceFirst("/", "");
                        }
                        if ((schemaLocation = schemaLocation.replace(pathFragment, "")).startsWith("/")) {
                            schemaLocation = schemaLocation.replaceFirst("/", "");
                        }
                        if ((policyLocation = policyLocation.replace(pathFragment, "")).startsWith("/")) {
                            policyLocation = policyLocation.replaceFirst("/", "");
                        }
                        if ((endpointLocation = endpointLocation.replace(pathFragment, "")).startsWith("/")) {
                            endpointLocation = endpointLocation.replaceFirst("/", "");
                        }
                        currentEnvironment = currentEnvironment.replace(pathFragment, "");
                    }
                    if (wsdlLocation.endsWith("/")) {
                        wsdlLocation = wsdlLocation.substring(0, wsdlLocation.length() - 1);
                    }
                    if (schemaLocation.endsWith("/")) {
                        schemaLocation = schemaLocation.substring(0, schemaLocation.length() - 1);
                    }
                    if (policyLocation.startsWith("/")) {
                        policyLocation = policyLocation.substring(0, policyLocation.length() - 1);
                    }
                    if (endpointLocation.startsWith("/")) {
                        endpointLocation = endpointLocation.substring(0, endpointLocation.length() - 1);
                    }
                    currentWsdlLocation = currentEnvironment + wsdlLocation;
                    currentSchemaLocation = currentEnvironment + schemaLocation;
                    String currentPolicyLocation = currentEnvironment + policyLocation;
                    currentEndpointLocation = currentEnvironment + endpointLocation;
                }
                if (masterVersion == null) {
                    String namespaceSegment = CommonUtil.derivePathFragmentFromNamespace(wsdlDefinition.getTargetNamespace()).replace("//", "/");
                    String suffix = resourcePath.substring(resourcePath.indexOf(namespaceSegment) + namespaceSegment.length());
                    masterVersion = suffix.substring(0, suffix.indexOf("/"));
                }
                wsdlPath = resourcePath;
                isDefaultEnvironment = false;
                for (Association association : associations = this.registry.getAssociations(wsdlPath, "depends")) {
                    if (!association.getSourcePath().equals(wsdlPath)) continue;
                    dependeinciesList.add(association.getDestinationPath());
                }
            }
            wsdlInfo.setProposedRegistryURL(wsdlPath);
        }
        String symlinkLocation = RegistryUtils.getAbsolutePath((RegistryContext)context.getRegistryContext(), (String)context.getResource().getProperty("SymlinkPropertyName"));
        if (!(symlinkLocation != null || resourcePath.equals("/") || resourcePath.equals(wsdlPath) || resourcePath.equals(""))) {
            symlinkLocation = RegistryUtils.getParentPath((String)resourcePath);
        }
        if (!isDefaultEnvironment) {
            this.schemaProcessor.saveSchemasToRegistry(context, currentSchemaLocation, null, null, masterVersion, dependeinciesList);
            this.updateWSDLSchemaLocations();
            masterWSDLPath = this.saveWSDLsToRepositoryNew(context, symlinkLocation, metadata, currentEndpointLocation, dependeinciesList, masterVersion);
            this.addPolicyImportys(context);
            this.saveAssociations();
        } else {
            this.schemaProcessor.saveSchemasToRegistry(context, this.getChrootedSchemaLocation(registryContext), null, null);
            this.updateWSDLSchemaLocations();
            masterWSDLPath = this.saveWSDLsToRepositoryNew(context, symlinkLocation, metadata);
            this.addPolicyImportys(context);
            this.saveAssociations();
            if (addService && this.getCreateService()) {
                List<OMElement> serviceContentBeans = this.createServiceContent(masterWSDLPath, metadata);
                for (OMElement serviceContentBean : serviceContentBeans) {
                    this.addService(serviceContentBean, context);
                }
            }
        }
        return masterWSDLPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPolicyImportys(RequestContext context) throws RegistryException {
        for (WSDLInfo wsdlInfo : this.wsdls.values()) {
            if (!wsdlInfo.isExistPolicyReferences()) continue;
            for (String policyURL : wsdlInfo.getPolicyDependencies()) {
                boolean lockAlreadyAcquired = !CommonUtil.isUpdateLockAvailable();
                CommonUtil.releaseUpdateLock();
                try {
                    Resource policyResource = this.registry.newResource();
                    policyResource.setMediaType("application/policy+xml");
                    String path = policyURL.substring(policyURL.lastIndexOf("/") + 1);
                    if (policyURL.lastIndexOf("/") <= 0) continue;
                    this.registry.importResource(path, policyURL, policyResource);
                    this.registry.addAssociation(this.getChrootedPolicyLocation(context.getRegistryContext()) + path, wsdlInfo.getProposedRegistryURL(), "usedBy");
                    this.registry.addAssociation(wsdlInfo.getProposedRegistryURL(), this.getChrootedPolicyLocation(context.getRegistryContext()) + path, "depends");
                }
                finally {
                    if (!lockAlreadyAcquired) continue;
                    CommonUtil.acquireUpdateLock();
                }
            }
        }
    }

    public WSDLInfo getMasterWSDLInfo() {
        for (WSDLInfo wsdlInfo : this.wsdls.values()) {
            if (!wsdlInfo.isMasterWSDL()) continue;
            return wsdlInfo;
        }
        return null;
    }

    private void saveAssociations() throws RegistryException {
        for (Association association : this.associations) {
            boolean isAssociationExist = false;
            Association[] existingAssociations = this.registry.getAllAssociations(association.getSourcePath());
            if (existingAssociations != null) {
                for (Association currentAssociation : existingAssociations) {
                    if (!currentAssociation.getDestinationPath().equals(association.getDestinationPath()) || !currentAssociation.getAssociationType().equals(association.getAssociationType())) continue;
                    isAssociationExist = true;
                    break;
                }
            }
            if (isAssociationExist) continue;
            this.registry.addAssociation(association.getSourcePath(), association.getDestinationPath(), association.getAssociationType());
        }
    }

    private String extractResourceFromURL(String wsdlURL, String suffix) {
        String resourceName = wsdlURL;
        if (wsdlURL.indexOf("?") > 0) {
            resourceName = wsdlURL.substring(0, wsdlURL.indexOf("?")) + suffix;
        } else if (wsdlURL.indexOf(".") > 0) {
            resourceName = wsdlURL.substring(0, wsdlURL.lastIndexOf(".")) + suffix;
        } else if (!wsdlURL.endsWith(".wsdl")) {
            resourceName = wsdlURL + suffix;
        }
        return resourceName;
    }

    private void evaluateWSDLsToDefinitions(String wsdlLocation, RequestContext context, boolean evaluateImports, boolean isServiceImport, boolean isPut, boolean skipValidation) throws RegistryException {
        Definition wsdlDefinition;
        block13: {
            ExWSDLReaderImpl wsdlReader;
            wsdlDefinition = null;
            this.originalDefinition = null;
            try {
                wsdlReader = new ExWSDLReaderImpl((WSDLReaderImpl)WSDLFactory.newInstance().newWSDLReader());
            }
            catch (WSDLException e) {
                String msg = "Could not initiate the wsdl reader. Caused by: " + e.getMessage();
                throw new RegistryException(msg);
            }
            wsdlReader.setFeature("javax.wsdl.importDocuments", true);
            wsdlReader.setFeature("javax.wsdl.verbose", log.isDebugEnabled());
            try {
                if (isPut) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])context.getResource().getContent());
                    InputSource inputSource = new InputSource(byteArrayInputStream);
                    wsdlDefinition = wsdlReader.readWSDL(null, inputSource);
                } else {
                    wsdlDefinition = wsdlReader.readWSDL(wsdlLocation);
                }
                this.originalDefinition = wsdlDefinition;
            }
            catch (WSDLException e) {
                String msg = "Could not evaluate WSDL Definition.";
                if (e.getCause() instanceof ConnectException || e.getCause() instanceof UnknownHostException) {
                    msg = msg + " Unable to resolve imported document at '" + wsdlLocation + "'. Connection refused.";
                    log.error((Object)msg, (Throwable)e);
                }
                if (!(e.getCause() instanceof IOException)) break block13;
                msg = msg + " This WSDL file or one of its imports was not found.";
                log.error((Object)msg, (Throwable)e);
            }
        }
        if (!isServiceImport) {
            this.processedWSDLs.add(this.resourceName);
        }
        Map map = null;
        if (wsdlDefinition != null) {
            map = wsdlDefinition.getImports();
        }
        if (!skipValidation) {
            if (map != null && map.size() == 0) {
                log.trace((Object)"Starting WSDL Validation");
                this.wsdlValidationInfo = WSDLUtils.validateWSDL(context);
                log.trace((Object)"Ending WSDL Validation");
                log.trace((Object)"Starting WSI Validation");
                this.wsiValidationInfo = WSDLUtils.validateWSI(context);
                log.trace((Object)"Ending WSI Validation");
            } else {
                this.hasWSDLImports = true;
            }
        }
        if (wsdlDefinition == null) {
            log.trace((Object)"Invalid WSDL definition found.");
            throw new RegistryException("Invalid WSDL definition found.");
        }
        this.evaluateWSDLsToDefinitionsRecursively(wsdlDefinition, evaluateImports, isServiceImport, null, true);
    }

    private void evaluateWSDLsToDefinitionsRecursively(Definition wsdlDefinition, boolean evaluateImports, boolean isServiceImport, WSDLInfo parent, boolean masterWSDL) throws RegistryException {
        String fileNameToSave;
        WSDLInfo wsdlInfo = new WSDLInfo();
        wsdlInfo.setMasterWSDL(masterWSDL);
        wsdlInfo.setParent(parent);
        if (evaluateImports) {
            Iterator iter = wsdlDefinition.getImports().values().iterator();
            this.visitedWSDLs.add(wsdlDefinition.getDocumentBaseURI());
            CommonUtil.addImportedArtifact(new File(wsdlDefinition.getDocumentBaseURI()).toString());
            while (iter.hasNext()) {
                Vector values = (Vector)iter.next();
                for (Object value : values) {
                    Import wsdlImport = (Import)value;
                    Definition innerDefinition = wsdlImport.getDefinition();
                    if (innerDefinition == null || innerDefinition.getTargetNamespace() == null) continue;
                    wsdlInfo.getWSDLDependencies().add(innerDefinition.getDocumentBaseURI());
                    if (this.visitedWSDLs.contains(innerDefinition.getDocumentBaseURI())) continue;
                    this.evaluateWSDLsToDefinitionsRecursively(innerDefinition, evaluateImports, isServiceImport, wsdlInfo, false);
                }
            }
        }
        for (Binding binding : wsdlDefinition.getBindings().values()) {
            if (binding.getBindingPolicyReference() == null) continue;
            wsdlInfo.setExistPolicyReferences(true);
            wsdlInfo.getPolicyDependencies().add(binding.getBindingPolicyReference().getURI());
        }
        String baseURI = wsdlDefinition.getDocumentBaseURI();
        if (baseURI != null) {
            String wsdlFileName = baseURI.substring(baseURI.lastIndexOf("/") + 1);
            if (baseURI.equals(this.originalDefinition.getDocumentBaseURI()) && !isServiceImport) {
                fileNameToSave = this.extractResourceFromURL(this.resourceName, ".wsdl");
            } else {
                fileNameToSave = this.extractResourceFromURL(wsdlFileName, ".wsdl");
                while (this.processedWSDLs.contains(fileNameToSave)) {
                    fileNameToSave = this.extractResourceFromURL(wsdlFileName, ++this.i + ".wsdl");
                }
            }
            wsdlInfo.setOriginalURL(baseURI);
        } else {
            fileNameToSave = this.extractResourceFromURL(this.resourceName, ".wsdl");
            wsdlInfo.setOriginalURL(SAMPLE_BASE_URL);
            wsdlDefinition.setDocumentBaseURI(SAMPLE_BASE_URL);
        }
        wsdlInfo.setWSDLDefinition(wsdlDefinition);
        wsdlInfo.setProposedRegistryURL(fileNameToSave);
        this.wsdls.put(baseURI, wsdlInfo);
        this.processedWSDLs.add(fileNameToSave);
    }

    private void updateWSDLSchemaLocations() throws RegistryException {
        this.updateWSDLocations();
        for (WSDLInfo wsdlInfo : this.wsdls.values()) {
            Definition definition = wsdlInfo.getWSDLDefinition();
            Types types = definition.getTypes();
            if (types == null) continue;
            List extensibleElements = types.getExtensibilityElements();
            for (Object extensibleElement : extensibleElements) {
                Object extensionObject = extensibleElement;
                if (!(extensionObject instanceof Schema)) continue;
                Schema schemaExtension = (Schema)extensionObject;
                NodeList nodeList = schemaExtension.getElement().getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String tagName = nodeList.item(i).getLocalName();
                    if (!IMPORT_TAG.equals(tagName) && !INCLUDE_TAG.equals(tagName)) continue;
                    NamedNodeMap nodeMap = nodeList.item(i).getAttributes();
                    for (int j = 0; j < nodeMap.getLength(); ++j) {
                        Node attribute = nodeMap.item(j);
                        if (!attribute.getNodeName().equals("schemaLocation")) continue;
                        String attributeValue = attribute.getNodeValue();
                        String schemaPath = this.schemaProcessor.getSchemaRegistryPath(wsdlInfo.getProposedRegistryURL(), attributeValue);
                        if (schemaPath == null) continue;
                        attribute.setNodeValue(schemaPath);
                    }
                }
            }
        }
    }

    private void updateWSDLocations() {
        for (WSDLInfo wsdlInfo : this.wsdls.values()) {
            Definition definition = wsdlInfo.getWSDLDefinition();
            ArrayList<String> wsdlDependancies = wsdlInfo.getWSDLDependencies();
            Vector[] importVector = definition.getImports().values().toArray(new Vector[definition.getImports().values().size()]);
            int count = 0;
            for (String wsdlDependancy : wsdlDependancies) {
                Vector values = importVector[count];
                WSDLInfo dependantWSDLInfo = this.wsdls.get(wsdlDependancy);
                dependantWSDLInfo.getProposedRegistryURL();
                for (Object value : values) {
                    Import importedWSDL = (Import)value;
                    String relativeSchemaPath = WSDLUtil.computeRelativePathWithVersion(wsdlInfo.getProposedRegistryURL(), dependantWSDLInfo.getProposedRegistryURL(), this.registry);
                    importedWSDL.setLocationURI(relativeSchemaPath);
                }
                ++count;
            }
        }
    }

    private void identifyAssociationsNew(WSDLInfo wsdlInfo) {
        String wsdlPath = wsdlInfo.getProposedRegistryURL();
        for (String association : wsdlInfo.getSchemaDependencies()) {
            String associatedTo = this.schemaProcessor.getSchemaAssociationPath(association);
            if (associatedTo == null) continue;
            this.associations.add(new Association(wsdlPath, associatedTo, "depends"));
            this.associations.add(new Association(associatedTo, wsdlPath, "usedBy"));
        }
        for (String association : wsdlInfo.getWSDLDependencies()) {
            String associatedTo;
            WSDLInfo info = this.wsdls.get(association);
            if (info == null || (associatedTo = info.getProposedRegistryURL()) == null) continue;
            this.associations.add(new Association(wsdlPath, associatedTo, "depends"));
            this.associations.add(new Association(associatedTo, wsdlPath, "usedBy"));
        }
    }

    private String saveWSDLsToRepositoryNew(RequestContext context, String symlinkLocation, Resource metaDataResource) throws RegistryException {
        String masterWSDLPath = null;
        try {
            for (WSDLInfo wsdlInfo : this.wsdls.values()) {
                ResourceImpl wsdlResource;
                Definition wsdlDefinition = wsdlInfo.getWSDLDefinition();
                WSDLWriter wsdlWriter = WSDLFactory.newInstance().newWSDLWriter();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                wsdlWriter.writeWSDL(wsdlDefinition, (OutputStream)byteArrayOutputStream);
                byte[] wsdlResourceContent = byteArrayOutputStream.toByteArray();
                String wsdlPath = wsdlInfo.getProposedRegistryURL();
                if (metaDataResource != null && this.registry.resourceExists(wsdlPath)) {
                    wsdlResource = this.registry.get(wsdlPath);
                } else {
                    Properties properties;
                    wsdlResource = new ResourceImpl();
                    if (metaDataResource != null && (properties = metaDataResource.getProperties()) != null) {
                        List<String> linkProperties = Arrays.asList("registry.link", "registry.user", "registry.mount", "registry.author", "registry.mountpoint", "registry.targetpoint", "registry.actualpath", "registry.realpath");
                        for (Map.Entry<Object, Object> e : properties.entrySet()) {
                            String key = (String)e.getKey();
                            if (linkProperties.contains(key)) continue;
                            wsdlResource.setProperty(key, (List)e.getValue());
                        }
                    }
                }
                this.copyAllParameters(wsdlPath, (Resource)wsdlResource);
                masterWSDLPath = this.addProperties(masterWSDLPath, wsdlInfo, wsdlDefinition, wsdlResourceContent, wsdlPath, (Resource)wsdlResource);
                if (metaDataResource != null) {
                    wsdlResource.setDescription(metaDataResource.getDescription());
                }
                boolean newWSDLUpload = !this.registry.resourceExists(wsdlPath);
                this.deleteOldResource(context, metaDataResource, wsdlInfo, wsdlPath, (Resource)wsdlResource);
                this.saveResource(context, wsdlInfo.getOriginalURL(), wsdlPath, (Resource)wsdlResource, true);
                if (this.systemRegistry != null) {
                    EndpointUtils.saveEndpointsFromWSDL(wsdlPath, (Resource)wsdlResource, this.registry, this.systemRegistry);
                }
                symlinkLocation = this.createLinks(symlinkLocation, wsdlInfo, wsdlPath, newWSDLUpload);
                this.identifyAssociationsNew(wsdlInfo);
            }
        }
        catch (WSDLException e) {
            throw new RegistryException("Invalid WSDL file");
        }
        return masterWSDLPath;
    }

    private String createLinks(String symlinkLocation, WSDLInfo wsdlInfo, String wsdlPath, boolean newWSDLUpload) throws RegistryException {
        if (wsdlInfo.isMasterWSDL() && symlinkLocation != null) {
            String symlinkPath;
            Resource resource;
            if (!symlinkLocation.endsWith("/")) {
                symlinkLocation = symlinkLocation + "/";
            }
            if (this.registry.resourceExists(symlinkLocation) && (resource = this.registry.get(symlinkLocation)) != null) {
                String isLink = resource.getProperty("registry.link");
                String mountPoint = resource.getProperty("registry.mountpoint");
                String targetPoint = resource.getProperty("registry.targetpoint");
                String actualPath = resource.getProperty("registry.actualpath");
                if (isLink != null && mountPoint != null && targetPoint != null) {
                    symlinkLocation = actualPath + "/";
                }
            }
            if (!symlinkLocation.endsWith("/")) {
                symlinkLocation = symlinkLocation + "/";
            }
            if (!this.registry.resourceExists(symlinkPath = symlinkLocation + this.resourceName)) {
                if (CommonUtil.isSymbolicLinkMapExisting()) {
                    CommonUtil.addToSymbolicLinkMap(symlinkPath, wsdlPath);
                } else {
                    this.systemRegistry.createLink(symlinkPath, wsdlPath);
                }
            } else if (newWSDLUpload) {
                if (this.registry.get(symlinkPath).getProperty("registry.link") != null) {
                    String actualPath = this.registry.get(symlinkPath).getProperty("registry.actualpath");
                    if (!wsdlPath.equals(actualPath)) {
                        if (actualPath != null) {
                            this.registry.delete(actualPath);
                        }
                        if (CommonUtil.isSymbolicLinkMapExisting()) {
                            CommonUtil.addToSymbolicLinkMap(symlinkPath, wsdlPath);
                        } else {
                            this.systemRegistry.removeLink(symlinkPath);
                            this.systemRegistry.createLink(symlinkPath, wsdlPath);
                        }
                    }
                } else {
                    this.registry.delete(symlinkPath);
                }
            }
        }
        return symlinkLocation;
    }

    private String addProperties(String masterWSDLPath, WSDLInfo wsdlInfo, Definition wsdlDefinition, byte[] wsdlResourceContent, String wsdlPath, Resource wsdlResource) throws RegistryException {
        String document;
        String name;
        if (wsdlDefinition.getQName() != null && (name = wsdlDefinition.getQName().getLocalPart()) != null) {
            wsdlResource.addProperty("registry.wsdl.Name", name);
        }
        if (wsdlDefinition.getDocumentationElement() != null && (document = wsdlDefinition.getDocumentationElement().getTextContent()) != null) {
            wsdlResource.addProperty("registry.wsdl.documentation", document);
        }
        String targetNamespace = wsdlDefinition.getTargetNamespace();
        wsdlResource.addProperty("registry.wsdl.TargetNamespace", targetNamespace);
        wsdlResource.setMediaType("application/wsdl+xml");
        wsdlResource.setContent((Object)wsdlResourceContent);
        if (wsdlInfo.isMasterWSDL()) {
            int i;
            ArrayList<String> validationMessages;
            masterWSDLPath = wsdlPath;
            log.trace((Object)"Setting WSDL Validation properties");
            if (this.wsdlValidationInfo != null) {
                wsdlResource.setProperty("WSDL Validation", this.wsdlValidationInfo.getStatus());
                validationMessages = this.wsdlValidationInfo.getValidationMessages();
                if (validationMessages.size() > 0) {
                    i = 1;
                    for (String message : validationMessages) {
                        if (message == null) continue;
                        if (message.length() > 1000) {
                            message = message.substring(0, 997) + "...";
                        }
                        wsdlResource.setProperty("WSDL Validation Message " + i, message);
                        ++i;
                    }
                }
            } else if (this.hasWSDLImports) {
                wsdlResource.setProperty("WSDL Validation", "Validation is not supported for WSDLs containing WSDL imports.");
            }
            log.trace((Object)"Finished setting WSDL Validation properties");
            log.trace((Object)"Setting WSI Validation properties");
            if (this.wsiValidationInfo != null) {
                wsdlResource.setProperty("WSI Validation", this.wsiValidationInfo.getStatus());
                validationMessages = this.wsiValidationInfo.getValidationMessages();
                if (validationMessages.size() > 0) {
                    i = 1;
                    for (String message : validationMessages) {
                        if (message == null) continue;
                        if (message.length() > 1000) {
                            message = message.substring(0, 997) + "...";
                        }
                        wsdlResource.setProperty("WSI Validation Message " + i, message);
                        ++i;
                    }
                }
            } else if (this.hasWSDLImports) {
                wsdlResource.setProperty("WSI Validation", "Validation is not supported for WSDLs containing WSDL imports.");
            }
            log.trace((Object)"Finished setting WSI Validation properties");
        }
        return masterWSDLPath;
    }

    private void copyAllParameters(String wsdlPath, Resource wsdlResource) throws RegistryException {
        if (this.registry.resourceExists(wsdlPath)) {
            Resource oldWsdlResource = this.registry.get(wsdlPath);
            Properties properties = oldWsdlResource.getProperties();
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                if (e.getValue() instanceof String) {
                    wsdlResource.setProperty((String)e.getKey(), (String)e.getValue());
                    continue;
                }
                wsdlResource.setProperty((String)e.getKey(), (List)e.getValue());
            }
        }
    }

    private String saveWSDLsToRepositoryNew(RequestContext context, String symlinkLocation, Resource metaDataResource, String endpointEnvironment, List<String> dependenciesList, String version) throws RegistryException {
        String masterWSDLPath = null;
        try {
            for (WSDLInfo wsdlInfo : this.wsdls.values()) {
                ResourceImpl wsdlResource;
                Definition wsdlDefinition = wsdlInfo.getWSDLDefinition();
                WSDLWriter wsdlWriter = WSDLFactory.newInstance().newWSDLWriter();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                wsdlWriter.writeWSDL(wsdlDefinition, (OutputStream)byteArrayOutputStream);
                byte[] wsdlResourceContent = byteArrayOutputStream.toByteArray();
                String wsdlPath = wsdlInfo.getProposedRegistryURL();
                if (metaDataResource != null && this.registry.resourceExists(wsdlPath)) {
                    wsdlResource = this.registry.get(wsdlPath);
                } else {
                    Properties properties;
                    wsdlResource = new ResourceImpl();
                    if (metaDataResource != null && (properties = metaDataResource.getProperties()) != null) {
                        List<String> linkProperties = Arrays.asList("registry.link", "registry.user", "registry.mount", "registry.author", "registry.mountpoint", "registry.targetpoint", "registry.actualpath", "registry.realpath");
                        for (Map.Entry<Object, Object> e : properties.entrySet()) {
                            String key = (String)e.getKey();
                            if (linkProperties.contains(key)) continue;
                            wsdlResource.setProperty(key, (List)e.getValue());
                        }
                    }
                }
                if (this.registry.resourceExists(wsdlPath)) {
                    Resource oldWsdlResource = this.registry.get(wsdlPath);
                    Properties properties = oldWsdlResource.getProperties();
                    for (Map.Entry<Object, Object> e : properties.entrySet()) {
                        if (e.getValue() instanceof String) {
                            wsdlResource.setProperty((String)e.getKey(), (String)e.getValue());
                            continue;
                        }
                        wsdlResource.setProperty((String)e.getKey(), (List)e.getValue());
                    }
                }
                masterWSDLPath = this.addProperties(masterWSDLPath, wsdlInfo, wsdlDefinition, wsdlResourceContent, wsdlPath, (Resource)wsdlResource);
                if (metaDataResource != null) {
                    wsdlResource.setDescription(metaDataResource.getDescription());
                }
                boolean newWSDLUpload = !this.registry.resourceExists(wsdlPath);
                this.deleteOldResource(context, metaDataResource, wsdlInfo, wsdlPath, (Resource)wsdlResource);
                this.saveResource(context, wsdlInfo.getOriginalURL(), wsdlPath, (Resource)wsdlResource, true);
                if (this.systemRegistry != null) {
                    EndpointUtils.saveEndpointsFromWSDL(wsdlPath, (Resource)wsdlResource, this.registry, this.systemRegistry, endpointEnvironment, dependenciesList, version);
                }
                symlinkLocation = this.createLinks(symlinkLocation, wsdlInfo, wsdlPath, newWSDLUpload);
                this.identifyAssociationsNew(wsdlInfo);
            }
        }
        catch (WSDLException e) {
            throw new RegistryException("Invalid WSDL file");
        }
        return masterWSDLPath;
    }

    private void deleteOldResource(RequestContext context, Resource metaDataResource, WSDLInfo wsdlInfo, String wsdlPath, Resource wsdlResource) throws RegistryException {
        if (wsdlInfo.isMasterWSDL()) {
            if (metaDataResource != null) {
                wsdlResource.setUUID(metaDataResource.getUUID());
            }
            if (!wsdlPath.equals(context.getResourcePath().getPath()) && this.registry.resourceExists(context.getResourcePath().getPath())) {
                this.registry.delete(context.getResourcePath().getPath());
            }
        }
    }

    private List<OMElement> createServiceContent(String wsdlURL, Resource metadata) throws RegistryException {
        ArrayList<OMElement> serviceContentomelements = new ArrayList<OMElement>();
        if (this.originalDefinition != null) {
            Map servicesMap = this.originalDefinition.getServices();
            for (Object serviceObject : servicesMap.values()) {
                Element documentationElement;
                Service service = (Service)serviceObject;
                QName qname = service.getQName();
                OMFactory fac = OMAbstractFactory.getOMFactory();
                OMNamespace namespace = fac.createOMNamespace("http://www.wso2.org/governance/metadata", "");
                OMElement data = fac.createOMElement("serviceMetaData", namespace);
                OMElement wsdlurl = fac.createOMElement("wsdlURL", namespace);
                OMElement overview = fac.createOMElement("overview", namespace);
                OMElement interfaceelement = fac.createOMElement("interface", namespace);
                OMElement name = fac.createOMElement("name", namespace);
                name.setText(qname.getLocalPart());
                wsdlurl.setText(RegistryUtils.getRelativePath((RegistryContext)this.registry.getRegistryContext(), (String)wsdlURL));
                OMElement namespaceElement = fac.createOMElement("namespace", namespace);
                OMElement descriptionelement = fac.createOMElement("description", namespace);
                namespaceElement.setText(qname.getNamespaceURI());
                String description = metadata.getDescription();
                if (description == null && (documentationElement = this.originalDefinition.getDocumentationElement()) != null && documentationElement.getFirstChild() != null) {
                    Node firstChild = documentationElement.getFirstChild();
                    description = DOM2Writer.nodeToString((Node)firstChild);
                }
                descriptionelement.setText(description);
                overview.addChild((OMNode)name);
                overview.addChild((OMNode)namespaceElement);
                overview.addChild((OMNode)descriptionelement);
                interfaceelement.addChild((OMNode)wsdlurl);
                data.addChild((OMNode)overview);
                data.addChild((OMNode)interfaceelement);
                serviceContentomelements.add(data);
            }
        }
        return serviceContentomelements;
    }

    private void saveResource(RequestContext context, String url, String path, Resource resource, boolean isWSDL) throws RegistryException {
        log.trace((Object)"Started saving resource");
        String artifactId = resource.getUUID();
        if (artifactId == null) {
            artifactId = UUID.randomUUID().toString();
            resource.setUUID(artifactId);
        }
        String relativeArtifactPath = RegistryUtils.getRelativePath((RegistryContext)this.registry.getRegistryContext(), (String)path);
        relativeArtifactPath = RegistryUtils.getRelativePathToOriginal((String)relativeArtifactPath, (String)"/_system/governance");
        resource.setProperty("registry.WSDLImport", "true");
        if (!isWSDL) {
            this.registry.put(path, resource);
        } else {
            this.addWSDLToRegistry(context, path, url, resource, this.registry);
        }
        ((ResourceImpl)resource).setPath(relativeArtifactPath);
        log.trace((Object)"Finished saving resource");
    }

    protected void addWSDLToRegistry(RequestContext context, String path, String url, Resource resource, Registry registry) throws RegistryException {
        registry.put(path, resource);
    }

    protected SchemaProcessor buildSchemaProcessor(RequestContext requestContext, WSDLValidationInfo validationInfo) {
        return new SchemaProcessor(requestContext, validationInfo);
    }

    protected SchemaProcessor buildSchemaProcessor(RequestContext requestContext, WSDLValidationInfo validationInfo, boolean useOriginalSchema) {
        return new SchemaProcessor(requestContext, validationInfo, useOriginalSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addService(OMElement service, RequestContext context) throws RegistryException {
        Resource resource = this.registry.newResource();
        String tempNamespace = CommonUtil.derivePathFragmentFromNamespace(CommonUtil.getServiceNamespace(service));
        String path = this.getChrootedServiceLocation(this.registry, context.getRegistryContext()) + tempNamespace + CommonUtil.getServiceName(service);
        String content = service.toString();
        resource.setContent((Object)RegistryUtils.encodeString((String)content));
        resource.setMediaType("application/vnd.wso2-service+xml");
        boolean lockAlreadyAcquired = !CommonUtil.isUpdateLockAvailable();
        CommonUtil.releaseUpdateLock();
        try {
            if (this.registry.resourceExists(path)) {
                Resource existingResource = this.registry.get(path);
                resource.setUUID(existingResource.getUUID());
            }
            this.saveResource(context, CommonUtil.getWSDLURL(service), path, resource, false);
        }
        finally {
            if (lockAlreadyAcquired) {
                CommonUtil.acquireUpdateLock();
            }
        }
        this.registry.addAssociation(path, RegistryUtils.getAbsolutePath((RegistryContext)this.registry.getRegistryContext(), (String)CommonUtil.getWSDLURL(service)), "depends");
        this.registry.addAssociation(RegistryUtils.getAbsolutePath((RegistryContext)this.registry.getRegistryContext(), (String)CommonUtil.getWSDLURL(service)), path, "usedBy");
    }

    static {
        log = LogFactory.getLog(WSDLProcessor.class);
        importedWSDLs = new InheritableThreadLocal<Set<String>>(){

            @Override
            protected Set<String> initialValue() {
                return new ConcurrentSkipListSet<String>();
            }
        };
    }
}

