/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers.utils;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.extensions.handlers.utils.SchemaFileProcessor;

public class WSDLFileProcessor {
    private int i;
    public static final String IMPORT_TAG = "import";
    public static final String INCLUDE_TAG = "include";
    private List<Association> associationsBuffer = new ArrayList<Association>();
    static HashMap changed = new HashMap();
    static HashSet visited = new HashSet();

    public String saveWSDLFileToRegistry(RequestContext context, String location, String registryBasePath, boolean processImports, Resource metadata) throws RegistryException {
        String fileNameToSave;
        Definition wsdlDefinition;
        WSDLReader wsdlReader;
        Registry registry = context.getRegistry();
        try {
            wsdlReader = WSDLFactory.newInstance().newWSDLReader();
        }
        catch (WSDLException e) {
            String msg = "Could not initiate the wsdl reader. Caused by: " + e.getMessage();
            throw new RegistryException(msg);
        }
        wsdlReader.setFeature("javax.wsdl.importDocuments", true);
        wsdlReader.setFeature("javax.wsdl.verbose", false);
        try {
            wsdlDefinition = wsdlReader.readWSDL(location);
            String baseUri = wsdlDefinition.getDocumentBaseURI();
            String wsdlFileName = baseUri.substring(baseUri.lastIndexOf("/") + 1);
            fileNameToSave = this.getFileNameToSave(wsdlFileName, ".wsdl");
        }
        catch (WSDLException e) {
            String msg = "Could not read the wsdl at location " + location + ". Caused by: " + e.getMessage();
            throw new RegistryException(msg);
        }
        HashMap processedWSDLMap = new HashMap();
        this.calculateWSDLNamesAndChangeTypes(registry, wsdlDefinition, processedWSDLMap, new HashMap(), new HashSet(), registryBasePath, processImports);
        this.saveWSDLFileToRegistry(registry, wsdlDefinition, processedWSDLMap, new HashSet(), registryBasePath, processImports, metadata, true);
        this.persistAssociations(registry, this.associationsBuffer);
        return fileNameToSave;
    }

    private String getFileNameToSave(String wsdlFileName, String suffix) {
        String fileNameToSave = wsdlFileName;
        if (wsdlFileName.indexOf(".") > 0) {
            fileNameToSave = wsdlFileName.substring(0, wsdlFileName.indexOf(".")) + suffix;
        } else if (wsdlFileName.indexOf("?") > 0) {
            fileNameToSave = wsdlFileName.substring(0, wsdlFileName.indexOf("?")) + suffix;
        } else if (!wsdlFileName.endsWith("wsdl")) {
            fileNameToSave = wsdlFileName + suffix;
        }
        return fileNameToSave;
    }

    public void calculateWSDLNamesAndChangeTypes(Registry registry, Definition wsdlDefinition, Map processedWSDLMap, Map processedScheamMap, Set visitedWSDLs, String registryBasePath, boolean processImports) throws RegistryException {
        if (processImports) {
            Iterator iter = wsdlDefinition.getImports().values().iterator();
            visitedWSDLs.add(wsdlDefinition.getDocumentBaseURI());
            while (iter.hasNext()) {
                Vector values = (Vector)iter.next();
                for (Object value : values) {
                    Import wsdlImport = (Import)value;
                    Definition innerDefinition = wsdlImport.getDefinition();
                    if (visitedWSDLs.contains(innerDefinition.getDocumentBaseURI())) continue;
                    this.calculateWSDLNamesAndChangeTypes(registry, innerDefinition, processedWSDLMap, processedScheamMap, visitedWSDLs, registryBasePath, processImports);
                }
            }
        }
        String baseUri = wsdlDefinition.getDocumentBaseURI();
        String wsdlFileName = baseUri.substring(baseUri.lastIndexOf("/") + 1);
        String fileNameToSave = this.getFileNameToSave(wsdlFileName, ".wsdl");
        while (processedWSDLMap.containsValue(fileNameToSave)) {
            fileNameToSave = this.getFileNameToSave(wsdlFileName, ++this.i + ".wsdl");
        }
        Types types = wsdlDefinition.getTypes();
        if (types != null) {
            List extensibleElements = types.getExtensibilityElements();
            String basuri = wsdlDefinition.getDocumentBaseURI();
            basuri = basuri.substring(0, basuri.lastIndexOf("/") + 1);
            for (Object extensibleElement : extensibleElements) {
                Object extensionObject = extensibleElement;
                if (!(extensionObject instanceof Schema)) continue;
                Schema schemaExtension = (Schema)extensionObject;
                XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();
                xmlSchemaCollection.setBaseUri(basuri);
                XmlSchema xmlSchema = xmlSchemaCollection.read(schemaExtension.getElement());
                SchemaFileProcessor schemaFileProcessor = new SchemaFileProcessor(registry);
                HashMap changedLocationMap = new HashMap();
                HashSet visitedSchemas = new HashSet();
                schemaFileProcessor.calculateNewSchemaNames(xmlSchema, processedScheamMap, visitedSchemas, true, processImports);
                schemaFileProcessor.saveSchemaFileToRegistry(xmlSchema, processedScheamMap, changedLocationMap, new HashSet(), true, registryBasePath, processImports, null);
                schemaFileProcessor.persistAssociations();
                ArrayList xsdPaths = schemaFileProcessor.getSchemaPath();
                for (Object xsdPath : xsdPaths) {
                    String xsd = (String)xsdPath;
                    String assocPath = "/" + fileNameToSave;
                    if (!"/".equals(registryBasePath)) {
                        assocPath = registryBasePath + assocPath;
                    }
                    this.associationsBuffer.add(new Association(assocPath, xsd, "depends"));
                    this.associationsBuffer.add(new Association(xsd, assocPath, "usedBy"));
                }
                this.changeLocations(schemaExtension.getElement(), changedLocationMap);
            }
        }
        processedWSDLMap.put(baseUri, fileNameToSave);
    }

    public void saveWSDLFileToRegistry(Registry registry, Definition wsdlDefinition, Map processedWSDLMap, Set visitedWSDLs, String registryBasePath, boolean processImports, Resource metadata, boolean original) throws RegistryException {
        ArrayList<String> associations = new ArrayList<String>();
        if (processImports) {
            Iterator iter = wsdlDefinition.getImports().values().iterator();
            visitedWSDLs.add(wsdlDefinition.getDocumentBaseURI());
            while (iter.hasNext()) {
                Vector values = (Vector)iter.next();
                for (Object value : values) {
                    Import wsdlImport = (Import)value;
                    Definition innerDefinition = wsdlImport.getDefinition();
                    if (!visitedWSDLs.contains(innerDefinition.getDocumentBaseURI())) {
                        this.saveWSDLFileToRegistry(registry, innerDefinition, processedWSDLMap, visitedWSDLs, registryBasePath, processImports, null, false);
                    }
                    wsdlImport.setLocationURI((String)processedWSDLMap.get(innerDefinition.getDocumentBaseURI()));
                    String innerImportedResourceName = (String)processedWSDLMap.get(innerDefinition.getDocumentBaseURI());
                    String innerWsdlPath = this.getWSDLPath(registryBasePath, innerImportedResourceName);
                    associations.add(innerWsdlPath);
                }
            }
        }
        String importedResourceName = (String)processedWSDLMap.get(wsdlDefinition.getDocumentBaseURI());
        try {
            String document;
            String name;
            WSDLWriter wsdlWriter = WSDLFactory.newInstance().newWSDLWriter();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            wsdlWriter.writeWSDL(wsdlDefinition, (OutputStream)byteArrayOutputStream);
            byte[] wsdlResourceContent = byteArrayOutputStream.toByteArray();
            String wsdlPath = this.getWSDLPath(registryBasePath, importedResourceName);
            ResourceImpl wsdlResource = new ResourceImpl();
            if (metadata != null) {
                wsdlResource.setMediaType(metadata.getMediaType());
                wsdlResource.setDescription(metadata.getDescription());
            }
            if (wsdlDefinition.getQName() != null && (name = wsdlDefinition.getQName().getLocalPart()) != null) {
                wsdlResource.addProperty("registry.wsdl.Name", name);
            }
            if (wsdlDefinition.getDocumentationElement() != null && (document = wsdlDefinition.getDocumentationElement().getTextContent()) != null) {
                wsdlResource.addProperty("registry.wsdl.documentation", document);
            }
            String targetNamespace = wsdlDefinition.getTargetNamespace();
            wsdlResource.addProperty("registry.wsdl.TargetNamespace", targetNamespace);
            wsdlResource.setContent((Object)wsdlResourceContent);
            registry.put(wsdlPath, (Resource)wsdlResource);
            if (metadata != null && original) {
                String document2;
                String name2;
                metadata.addProperty("registry.wsdl.TargetNamespace", targetNamespace);
                if (wsdlDefinition.getQName() != null && (name2 = wsdlDefinition.getQName().getLocalPart()) != null) {
                    metadata.addProperty("registry.wsdl.Name", name2);
                }
                if (wsdlDefinition.getDocumentationElement() != null && (document2 = wsdlDefinition.getDocumentationElement().getTextContent()) != null) {
                    metadata.addProperty("registry.wsdl.documentation", document2);
                }
            }
            for (Object e : associations) {
                String associatedWSDL = (String)e;
                this.associationsBuffer.add(new Association(wsdlPath, associatedWSDL, "depends"));
            }
        }
        catch (WSDLException e) {
            throw new RegistryException("Invalid WSDL file");
        }
    }

    private String getWSDLPath(String registryBasePath, String importedResourceName) {
        String wsdlPath = "/".equals(registryBasePath) ? "/" + importedResourceName : registryBasePath + "/" + importedResourceName;
        return wsdlPath;
    }

    private void changeLocations(Element element, Map changedLocationMap) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String tagName = nodeList.item(i).getLocalName();
            if (!IMPORT_TAG.equals(tagName) && !INCLUDE_TAG.equals(tagName)) continue;
            this.processImport(nodeList.item(i), changedLocationMap);
        }
    }

    private void processImport(Node importNode, Map changedLocationMap) {
        NamedNodeMap nodeMap = importNode.getAttributes();
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            String attributeValue;
            Node attribute = nodeMap.item(i);
            if (!attribute.getNodeName().equals("schemaLocation") || changedLocationMap.get(attributeValue = attribute.getNodeValue()) == null) continue;
            attribute.setNodeValue((String)changedLocationMap.get(attributeValue));
        }
    }

    private void persistAssociations(Registry registry, List<Association> associations) throws RegistryException {
        for (Association association : associations) {
            registry.addAssociation(association.getSourcePath(), association.getDestinationPath(), association.getAssociationType());
        }
    }
}

