/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.beans.BusinessServiceInfo;
import org.wso2.carbon.registry.extensions.handlers.WSDLMediaTypeHandler;
import org.wso2.carbon.registry.extensions.handlers.utils.SchemaProcessor;
import org.wso2.carbon.registry.extensions.handlers.utils.SchemaValidator;
import org.wso2.carbon.registry.extensions.handlers.utils.UDDIPublisher;
import org.wso2.carbon.registry.extensions.handlers.utils.WSDLInfo;
import org.wso2.carbon.registry.extensions.handlers.utils.WSDLProcessor;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;
import org.wso2.carbon.registry.extensions.utils.WSDLValidationInfo;
import org.wso2.carbon.user.core.UserRealm;

public class ZipWSDLMediaTypeHandler
extends WSDLMediaTypeHandler {
    private String wsdlMediaType = "application/wsdl+xml";
    private String wsdlExtension = ".wsdl";
    private String xsdMediaType = "application/xsd+xml";
    private String xsdExtension = ".xsd";
    private String archiveExtension = ".gar";
    private String tempFilePrefix = "wsdl";
    private boolean disableWSDLValidation = false;
    private boolean disableSchemaValidation = false;
    private boolean useOriginalSchema = false;
    private boolean disableSymlinkCreation = false;
    private static int numberOfRetry = 5;
    private int threadPoolSize = 50;
    private static final Log log = LogFactory.getLog(ZipWSDLMediaTypeHandler.class);

    public void setNumberOfRetry(String numberOfRetry) {
        ZipWSDLMediaTypeHandler.numberOfRetry = Integer.parseInt(numberOfRetry);
    }

    public boolean isDisableSymlinkCreation() {
        return this.disableSymlinkCreation;
    }

    public void setDisableSymlinkCreation(String disableSymlinkCreation) {
        this.disableSymlinkCreation = Boolean.toString(true).equals(disableSymlinkCreation);
    }

    public void setThreadPoolSize(String threadPoolSize) {
        this.threadPoolSize = Integer.parseInt(threadPoolSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        try {
            block49: {
                Resource resource = requestContext.getResource();
                String path = requestContext.getResourcePath().getPath();
                try {
                    if (requestContext.getRegistry().resourceExists(path)) {
                        return;
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                try {
                    if (resource == null) break block49;
                    Object resourceContent = resource.getContent();
                    ByteArrayInputStream in = new ByteArrayInputStream((byte[])resourceContent);
                    Stack<File> fileList = new Stack<File>();
                    LinkedList<String> uriList = new LinkedList<String>();
                    LinkedList<UploadTask> tasks = new LinkedList<UploadTask>();
                    int threadPoolSize = this.threadPoolSize;
                    int wsdlPathDepth = Integer.MAX_VALUE;
                    int xsdPathDepth = Integer.MAX_VALUE;
                    File tempFile = File.createTempFile(this.tempFilePrefix, this.archiveExtension);
                    File tempDir = new File(tempFile.getAbsolutePath().substring(0, tempFile.getAbsolutePath().length() - this.archiveExtension.length()));
                    try {
                        int toAdd;
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile));
                        try {
                            int byteCount;
                            byte[] contentChunk = new byte[1024];
                            while ((byteCount = in.read(contentChunk)) != -1) {
                                out.write(contentChunk, 0, byteCount);
                            }
                            out.flush();
                        }
                        finally {
                            out.close();
                        }
                        this.makeDir(tempDir);
                        LinkedList<String> wsdlUriList = new LinkedList<String>();
                        LinkedList<String> xsdUriList = new LinkedList<String>();
                        ZipInputStream zs = new ZipInputStream(new FileInputStream(tempFile));
                        try {
                            ZipEntry entry = zs.getNextEntry();
                            while (entry != null) {
                                int uriPathDepth;
                                String uri;
                                String entryName = entry.getName();
                                File file = new File(tempFile.getAbsolutePath().substring(0, tempFile.getAbsolutePath().length() - this.archiveExtension.length()) + File.separator + entryName);
                                if (entry.isDirectory()) {
                                    if (!file.exists()) {
                                        this.makeDirs(file);
                                        fileList.push(file);
                                    }
                                    entry = zs.getNextEntry();
                                    continue;
                                }
                                File parentFile = file.getParentFile();
                                if (!parentFile.exists()) {
                                    this.makeDirs(parentFile);
                                }
                                FileOutputStream os = new FileOutputStream(file);
                                try {
                                    int byteCount;
                                    fileList.push(file);
                                    byte[] contentChunk = new byte[1024];
                                    while ((byteCount = zs.read(contentChunk)) != -1) {
                                        os.write(contentChunk, 0, byteCount);
                                    }
                                }
                                finally {
                                    os.close();
                                }
                                zs.closeEntry();
                                entry = zs.getNextEntry();
                                if (entryName != null && entryName.toLowerCase().endsWith(this.wsdlExtension)) {
                                    uri = tempFile.toURI().toString();
                                    if ((uri = uri.substring(0, uri.length() - this.archiveExtension.length()) + "/" + entryName).startsWith("file:")) {
                                        uri = uri.substring(5);
                                    }
                                    while (uri.startsWith("/")) {
                                        uri = uri.substring(1);
                                    }
                                    uri = "file:///" + uri;
                                    if (uri.endsWith("/")) {
                                        uri = uri.substring(0, uri.length() - 1);
                                    }
                                    if ((uriPathDepth = uri.split("/").length) < wsdlPathDepth) {
                                        wsdlPathDepth = uriPathDepth;
                                        wsdlUriList = new LinkedList();
                                    }
                                    if (wsdlPathDepth != uriPathDepth) continue;
                                    wsdlUriList.add(uri);
                                    continue;
                                }
                                if (entryName != null && entryName.toLowerCase().endsWith(this.xsdExtension)) {
                                    uri = tempFile.toURI().toString();
                                    if ((uri = uri.substring(0, uri.length() - this.archiveExtension.length()) + "/" + entryName).startsWith("file:")) {
                                        uri = uri.substring(5);
                                    }
                                    while (uri.startsWith("/")) {
                                        uri = uri.substring(1);
                                    }
                                    uri = "file:///" + uri;
                                    if (uri.endsWith("/")) {
                                        uri = uri.substring(0, uri.length() - 1);
                                    }
                                    if ((uriPathDepth = uri.split("/").length) < xsdPathDepth) {
                                        xsdPathDepth = uriPathDepth;
                                        xsdUriList = new LinkedList();
                                    }
                                    if (xsdPathDepth != uriPathDepth) continue;
                                    xsdUriList.add(uri);
                                    continue;
                                }
                                if (entryName == null) continue;
                                uri = tempFile.toURI().toString();
                                if ((uri = uri.substring(0, uri.length() - this.archiveExtension.length()) + "/" + entryName).startsWith("file:")) {
                                    uri = uri.substring(5);
                                }
                                while (uri.startsWith("/")) {
                                    uri = uri.substring(1);
                                }
                                uri = "file:///" + uri;
                                if (uri.endsWith("/")) {
                                    uri = uri.substring(0, uri.length() - 1);
                                }
                                uriList.add(uri);
                            }
                        }
                        finally {
                            zs.close();
                        }
                        Map<String, String> localPathMap = null;
                        if (CurrentSession.getLocalPathMap() != null) {
                            localPathMap = Collections.unmodifiableMap(CurrentSession.getLocalPathMap());
                        }
                        if (wsdlUriList.isEmpty() && xsdUriList.isEmpty()) {
                            throw new RegistryException("No WSDLs or Schemas found in the given WSDL archive");
                        }
                        if (wsdlPathDepth < Integer.MAX_VALUE) {
                            for (String uri : wsdlUriList) {
                                tasks.add(new UploadWSDLTask(requestContext, uri, CurrentSession.getTenantId(), CurrentSession.getUserRegistry(), CurrentSession.getUserRealm(), CurrentSession.getUser(), CurrentSession.getCallerTenantId(), localPathMap));
                            }
                        }
                        if (xsdPathDepth < Integer.MAX_VALUE) {
                            for (String uri : xsdUriList) {
                                tasks.add(new UploadXSDTask(requestContext, uri, CurrentSession.getTenantId(), CurrentSession.getUserRegistry(), CurrentSession.getUserRealm(), CurrentSession.getUser(), CurrentSession.getCallerTenantId(), localPathMap));
                            }
                        }
                        if ((toAdd = wsdlUriList.size() + xsdUriList.size()) < threadPoolSize) {
                            threadPoolSize = toAdd < threadPoolSize / 8 ? 0 : (toAdd < threadPoolSize / 2 ? (threadPoolSize /= 8) : (threadPoolSize /= 4));
                        }
                    }
                    finally {
                        ((InputStream)in).close();
                        resourceContent = null;
                        resource.setContent(null);
                    }
                    this.uploadFiles(tasks, tempFile, fileList, tempDir, threadPoolSize, path, uriList, requestContext);
                }
                catch (IOException e) {
                    throw new RegistryException("Error occurred while unpacking Governance Archive", (Throwable)e);
                }
            }
            if (Transaction.isRollbacked()) {
                throw new RegistryException("A nested transaction was rollbacked and therefore cannot proceed with this action.");
            }
            requestContext.setProcessingComplete(true);
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }

    protected String addWSDLFromZip(RequestContext requestContext, String uri) throws RegistryException {
        if (uri != null) {
            Resource local = requestContext.getRegistry().newResource();
            local.setMediaType(this.wsdlMediaType);
            requestContext.setSourceURL(uri);
            requestContext.setResource(local);
            String path = requestContext.getResourcePath().getPath();
            path = path.lastIndexOf("/") != -1 ? path.substring(0, path.lastIndexOf("/")) : "";
            String wsdlName = uri;
            wsdlName = wsdlName.lastIndexOf("/") != -1 ? wsdlName.substring(wsdlName.lastIndexOf("/")) : "/" + wsdlName;
            path = path + wsdlName;
            requestContext.setResourcePath(new ResourcePath(path));
            WSDLProcessor wsdlProcessor = this.buildWSDLProcessor(requestContext, this.useOriginalSchema);
            String addedPath = wsdlProcessor.addWSDLToRegistry(requestContext, uri, local, false, true, this.disableWSDLValidation);
            if ("enable".equals(System.getProperty("uddi"))) {
                BusinessServiceInfo businessServiceInfo = new BusinessServiceInfo();
                WSDLInfo wsdlInfo = wsdlProcessor.getMasterWSDLInfo();
                businessServiceInfo.setServiceWSDLInfo(wsdlInfo);
                UDDIPublisher publisher = new UDDIPublisher(businessServiceInfo);
                publisher.publishBusinessService();
            }
            log.debug((Object)("WSDL : " + addedPath));
            return addedPath;
        }
        return null;
    }

    protected String addSchemaFromZip(RequestContext requestContext, String uri) throws RegistryException {
        if (uri != null) {
            Resource local = requestContext.getRegistry().newResource();
            local.setMediaType(this.xsdMediaType);
            requestContext.setSourceURL(uri);
            requestContext.setResource(local);
            String path = requestContext.getResourcePath().getPath();
            path = path.lastIndexOf("/") != -1 ? path.substring(0, path.lastIndexOf("/")) : "";
            String xsdName = uri;
            xsdName = xsdName.lastIndexOf("/") != -1 ? xsdName.substring(xsdName.lastIndexOf("/")) : "/" + xsdName;
            path = path + xsdName;
            requestContext.setResourcePath(new ResourcePath(path));
            WSDLValidationInfo validationInfo = null;
            try {
                if (!this.disableSchemaValidation) {
                    validationInfo = SchemaValidator.validate(new XMLInputSource(null, uri, null));
                }
            }
            catch (Exception e) {
                throw new RegistryException("Exception occured while validating the schema", (Throwable)e);
            }
            SchemaProcessor schemaProcessor = this.buildSchemaProcessor(requestContext, validationInfo, this.useOriginalSchema);
            String savedName = schemaProcessor.importSchemaToRegistry(requestContext, path, this.getChrootedLocation(requestContext.getRegistryContext()), true);
            String parentPath = RegistryUtils.getParentPath((String)requestContext.getResourcePath().getPath());
            if (parentPath.startsWith("//")) {
                parentPath = parentPath.substring(1);
            }
            if (parentPath.endsWith("/")) {
                requestContext.setActualPath(parentPath + savedName);
            } else {
                requestContext.setActualPath(parentPath + "/" + savedName);
            }
            String addedPath = requestContext.getActualPath();
            log.debug((Object)("XSD : " + addedPath));
            return addedPath;
        }
        return null;
    }

    private String getChrootedLocation(RegistryContext registryContext) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)("/_system/governance" + this.schemaLocation));
    }

    @Override
    public void importResource(RequestContext context) {
        log.warn((Object)"The imported Governance Web Archive will not be extracted. To extract the content upload the archive from the file system.");
    }

    public void setWsdlMediaType(String wsdlMediaType) {
        this.wsdlMediaType = wsdlMediaType;
    }

    public void setWsdlExtension(String wsdlExtension) {
        this.wsdlExtension = wsdlExtension;
    }

    public void setSchemaMediaType(String xsdMediaType) {
        this.xsdMediaType = xsdMediaType;
    }

    public void setSchemaExtension(String xsdExtension) {
        this.xsdExtension = xsdExtension;
    }

    public void setArchiveExtension(String archiveExtension) {
        this.archiveExtension = archiveExtension;
    }

    public void setTempFilePrefix(String tempFilePrefix) {
        this.tempFilePrefix = tempFilePrefix;
    }

    @Override
    public void setDisableWSDLValidation(String disableWSDLValidation) {
        this.disableWSDLValidation = Boolean.toString(true).equals(disableWSDLValidation);
    }

    public void setDisableSchemaValidation(String disableSchemaValidation) {
        this.disableSchemaValidation = Boolean.toString(true).equals(disableSchemaValidation);
    }

    public void setUseOriginalSchema(String useOriginalSchema) {
        this.useOriginalSchema = Boolean.toString(true).equals(useOriginalSchema);
    }

    @Override
    protected void onPutCompleted(String path, Map<String, String> addedResources, List<String> otherResources, RequestContext requestContext) throws RegistryException {
        log.info((Object)("Total Number of Files Uploaded: " + addedResources.size()));
        LinkedList<String> failures = new LinkedList<String>();
        for (Map.Entry<String, String> e : addedResources.entrySet()) {
            if (e.getValue() != null) continue;
            failures.add(e.getKey());
            log.info((Object)("Failure " + failures.size() + ": " + e.getKey()));
        }
        log.info((Object)("Total Number of Files Failed to Upload: " + failures.size()));
        if (otherResources.size() > 0) {
            log.info((Object)("Total Number of Files Not-Uploaded: " + otherResources.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uploadFiles(List<UploadTask> tasks, File tempFile, Stack<File> fileList, File tempDir, int poolSize, String path, List<String> uriList, RequestContext requestContext) throws RegistryException {
        block30: {
            block29: {
                CommonUtil.loadImportedArtifactMap();
                try {
                    if (poolSize <= 0) {
                        boolean updateLockAvailable = CommonUtil.isUpdateLockAvailable();
                        if (!updateLockAvailable) {
                            CommonUtil.releaseUpdateLock();
                        }
                        try {
                            for (UploadTask uploadTask : tasks) {
                                uploadTask.run();
                            }
                            break block29;
                        }
                        finally {
                            if (!updateLockAvailable) {
                                CommonUtil.acquireUpdateLock();
                            }
                        }
                    }
                    ExecutorService executorService = Executors.newFixedThreadPool(poolSize);
                    if (!CommonUtil.isArtifactIndexMapExisting()) {
                        CommonUtil.createArtifactIndexMap();
                    }
                    if (!CommonUtil.isSymbolicLinkMapExisting()) {
                        CommonUtil.createSymbolicLinkMap();
                    }
                    for (UploadTask uploadTask : tasks) {
                        executorService.submit(uploadTask);
                    }
                    executorService.shutdown();
                    while (!executorService.isTerminated()) {
                    }
                }
                finally {
                    CommonUtil.clearImportedArtifactMap();
                }
            }
            try {
                if (CommonUtil.isArtifactIndexMapExisting()) {
                    Map<String, String> artifactIndexMap = CommonUtil.getAndRemoveArtifactIndexMap();
                    if (log.isDebugEnabled()) {
                        for (Map.Entry entry : artifactIndexMap.entrySet()) {
                            log.debug((Object)("Added Artifact Entry: " + (String)entry.getKey()));
                        }
                    }
                }
                Registry registry = requestContext.getRegistry();
                if (this.isDisableSymlinkCreation() || !CommonUtil.isSymbolicLinkMapExisting()) break block30;
                Map<String, String> symbolicLinkMap = CommonUtil.getAndRemoveSymbolicLinkMap();
                for (Map.Entry<String, String> entry : symbolicLinkMap.entrySet()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Added Symbolic Link: " + entry.getKey()));
                    }
                    try {
                        if (registry.resourceExists(entry.getKey())) {
                            registry.removeLink(entry.getKey());
                        }
                    }
                    catch (RegistryException ignored) {
                        // empty catch block
                    }
                    requestContext.getSystemRegistry().createLink(entry.getKey(), entry.getValue());
                }
            }
            catch (RegistryException e) {
                log.error((Object)"Unable to build artifact index.", (Throwable)e);
            }
        }
        LinkedHashMap<String, String> taskResults = new LinkedHashMap<String, String>();
        for (UploadTask uploadTask : tasks) {
            if (uploadTask.getFailed()) {
                taskResults.put(uploadTask.getUri(), null);
                continue;
            }
            taskResults.put(uploadTask.getUri(), uploadTask.getResult());
        }
        this.onPutCompleted(path, taskResults, uriList, requestContext);
        try {
            this.delete(tempFile);
            while (!fileList.isEmpty()) {
                this.delete(fileList.pop());
            }
            FileUtils.deleteDirectory((File)tempDir);
        }
        catch (IOException e) {
            log.error((Object)"Unable to cleanup temporary files", (Throwable)e);
        }
        log.info((Object)"Completed uploading files from archive file");
    }

    protected class UploadWSDLTask
    extends UploadTask {
        public UploadWSDLTask(RequestContext requestContext, String uri, int tenantId, UserRegistry userRegistry, UserRealm userRealm, String userId, int callerTenantId, Map<String, String> localPathMap) {
            super(requestContext, uri, tenantId, userRegistry, userRealm, userId, callerTenantId, localPathMap);
        }

        @Override
        protected void doProcessing(RequestContext requestContext, String uri) throws RegistryException {
            this.result = ZipWSDLMediaTypeHandler.this.addWSDLFromZip(requestContext, uri);
        }
    }

    protected class UploadXSDTask
    extends UploadTask {
        public UploadXSDTask(RequestContext requestContext, String uri, int tenantId, UserRegistry userRegistry, UserRealm userRealm, String userId, int callerTenantId, Map<String, String> localPathMap) {
            super(requestContext, uri, tenantId, userRegistry, userRealm, userId, callerTenantId, localPathMap);
        }

        @Override
        protected void doProcessing(RequestContext requestContext, String uri) throws RegistryException {
            this.result = ZipWSDLMediaTypeHandler.this.addSchemaFromZip(requestContext, uri);
        }
    }

    protected static abstract class UploadTask
    implements Runnable {
        private String uri;
        private RequestContext requestContext;
        private int tenantId = -1;
        private UserRegistry userRegistry;
        private UserRealm userRealm;
        private String userId;
        private int callerTenantId;
        private Map<String, String> localPathMap;
        private Random random = new Random(10L);
        protected String result = null;
        protected boolean failed = false;
        protected int retries = 0;

        public UploadTask(RequestContext requestContext, String uri, int tenantId, UserRegistry userRegistry, UserRealm userRealm, String userId, int callerTenantId, Map<String, String> localPathMap) {
            this.userRegistry = userRegistry;
            this.userRealm = userRealm;
            this.tenantId = tenantId;
            this.requestContext = requestContext;
            this.uri = uri;
            this.userId = userId;
            this.callerTenantId = callerTenantId;
            this.localPathMap = localPathMap;
        }

        @Override
        public void run() {
            if (CommonUtil.isImportedArtifactExisting(new File(this.uri).toString())) {
                this.failed = false;
                this.result = "added from import";
                return;
            }
            this.doWork();
        }

        protected void retry() {
            if (this.retries < numberOfRetry) {
                ++this.retries;
                log.info((Object)("Retrying to upload resource: " + this.uri));
                int i = this.random.nextInt(10);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Waiting for " + i + " seconds"));
                }
                try {
                    Thread.sleep(1000 * i);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.doWork();
            } else {
                this.failed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doWork() {
            block12: {
                CurrentSession.setTenantId((int)this.tenantId);
                CurrentSession.setUserRegistry((UserRegistry)this.userRegistry);
                CurrentSession.setUserRealm((UserRealm)this.userRealm);
                CurrentSession.setUser((String)this.userId);
                CurrentSession.setCallerTenantId((int)this.callerTenantId);
                if (this.localPathMap != null) {
                    CurrentSession.setLocalPathMap(this.localPathMap);
                }
                try {
                    if (!CommonUtil.isUpdateLockAvailable()) break block12;
                    CommonUtil.acquireUpdateLock();
                    try {
                        RequestContext requestContext = new RequestContext(this.requestContext.getRegistry(), this.requestContext.getRepository(), this.requestContext.getVersionRepository());
                        requestContext.setResourcePath(this.requestContext.getResourcePath());
                        requestContext.setResource(this.requestContext.getResource());
                        requestContext.setOldResource(this.requestContext.getOldResource());
                        this.doProcessing(requestContext, this.uri);
                    }
                    finally {
                        CommonUtil.releaseUpdateLock();
                    }
                }
                catch (RegistryException e) {
                    log.error((Object)("An error occurred while  uploading " + this.uri), (Throwable)e);
                    this.retry();
                }
                catch (RuntimeException e) {
                    log.error((Object)("An unhandled exception occurred while  uploading " + this.uri), (Throwable)e);
                    this.retry();
                }
                finally {
                    CurrentSession.removeUser();
                    CurrentSession.removeUserRealm();
                    CurrentSession.removeUserRegistry();
                    CurrentSession.removeTenantId();
                    CurrentSession.removeCallerTenantId();
                    if (this.localPathMap != null) {
                        CurrentSession.removeLocalPathMap();
                    }
                    this.requestContext = null;
                }
            }
        }

        protected abstract void doProcessing(RequestContext var1, String var2) throws RegistryException;

        public String getUri() {
            return this.uri;
        }

        public String getResult() {
            return this.result;
        }

        public boolean getFailed() {
            return this.failed;
        }
    }
}

