/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;

public class SynapseRepositoryHandler
extends Handler {
    private static final Log log = LogFactory.getLog(SynapseRepositoryHandler.class);

    public Resource get(RequestContext requestContext) throws RegistryException {
        return null;
    }

    public void put(RequestContext requestContext) throws RegistryException {
        String path = requestContext.getResourcePath().getPath();
        String confPath = path + "/" + "conf";
        CollectionImpl confCollection = new CollectionImpl();
        confCollection.setPath(confPath);
        confCollection.setMediaType("synapse-conf");
        requestContext.getRegistry().put(confPath, (Resource)confCollection);
        String seqPath = path + "/" + "sequences";
        CollectionImpl seqCollection = new CollectionImpl();
        seqCollection.setPath(seqPath);
        seqCollection.setMediaType("synapse-sequences");
        requestContext.getRegistry().put(seqPath, (Resource)seqCollection);
        String epPath = path + "/" + "endpoints";
        CollectionImpl epCollection = new CollectionImpl();
        epCollection.setPath(epPath);
        epCollection.setMediaType("synapse-endpoints");
        requestContext.getRegistry().put(epPath, (Resource)epCollection);
        String proxyServicesPath = path + "/" + "proxy-services";
        CollectionImpl proxyCollection = new CollectionImpl();
        proxyCollection.setPath(proxyServicesPath);
        proxyCollection.setMediaType("synapse-proxy-services");
        requestContext.getRegistry().put(proxyServicesPath, (Resource)proxyCollection);
        String tasksPath = path + "/" + "tasks";
        CollectionImpl tasksCollection = new CollectionImpl();
        tasksCollection.setPath(tasksPath);
        tasksCollection.setMediaType("synapse-tasks");
        requestContext.getRegistry().put(tasksPath, (Resource)tasksCollection);
        String entriesPath = path + "/" + "entries";
        CollectionImpl entryCollection = new CollectionImpl();
        entryCollection.setPath(entriesPath);
        entryCollection.setMediaType("synapse-entries");
        requestContext.getRegistry().put(entriesPath, (Resource)entryCollection);
    }

    public void importResource(RequestContext requestContext) throws RegistryException {
    }

    public void delete(RequestContext requestContext) throws RegistryException {
    }

    public void putChild(RequestContext requestContext) throws RegistryException {
        String childMediaType;
        Resource childResource = requestContext.getResource();
        if (childResource == null) {
            childResource = requestContext.getRegistry().get(requestContext.getResourcePath().getPath());
            requestContext.setResource(childResource);
        }
        if (!("synapse-conf".equals(childMediaType = requestContext.getResource().getMediaType()) || "synapse-sequences".equals(childMediaType) || "synapse-endpoints".equals(childMediaType) || "synapse-proxy-services".equals(childMediaType) || "synapse-tasks".equals(childMediaType) || "synapse-entries".equals(childMediaType))) {
            String msg = "Resources of type: " + childMediaType + " are not allowed to add as child resources of " + "the typed collection Synapse Repository.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
    }

    public void importChild(RequestContext requestContext) throws RegistryException {
    }
}

