/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.beans.BusinessServiceInfo;
import org.wso2.carbon.registry.extensions.handlers.utils.EndpointUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.ServiceUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.UDDIPublisher;
import org.wso2.carbon.registry.extensions.handlers.utils.WSDLInfo;
import org.wso2.carbon.registry.extensions.handlers.utils.WSDLProcessor;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class ServiceMediaTypeHandler
extends Handler {
    private static final Log log = LogFactory.getLog(ServiceMediaTypeHandler.class);
    private static final String TRUNK = "trunk";
    private String defaultEnvironment;
    private boolean disableWSDLValidation = false;
    private List<String> smartLifecycleLinks = new LinkedList<String>();
    private String defaultServiceVersion = "1.0.0-SNAPSHOT";

    public void setDefaultServiceVersion(String defaultServiceVersion) {
        this.defaultServiceVersion = defaultServiceVersion;
    }

    public void setSmartLifecycleLinks(OMElement locationConfiguration) throws RegistryException {
        Iterator confElements = locationConfiguration.getChildElements();
        while (confElements.hasNext()) {
            OMElement confElement = (OMElement)confElements.next();
            if (!confElement.getQName().equals(new QName("key"))) continue;
            this.smartLifecycleLinks.add(confElement.getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(RequestContext requestContext) throws RegistryException {
        WSDLProcessor wsdl = null;
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        try {
            String serviceId;
            OMElement serviceInfoElement;
            Registry registry = requestContext.getRegistry();
            Resource resource = requestContext.getResource();
            if (resource == null) {
                throw new RegistryException("The resource is not available.");
            }
            String originalServicePath = requestContext.getResourcePath().getPath();
            String resourceName = RegistryUtils.getResourceName((String)originalServicePath);
            OMElement previousServiceInfoElement = null;
            Object resourceContent = resource.getContent();
            String serviceInfo = resourceContent instanceof String ? (String)resourceContent : RegistryUtils.decodeBytes((byte[])((byte[])resourceContent));
            try {
                XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(serviceInfo));
                StAXOMBuilder builder = new StAXOMBuilder(reader);
                serviceInfoElement = builder.getDocumentElement();
            }
            catch (Exception e) {
                String msg = "Error in parsing the service content of the service. The requested path to store the service: " + originalServicePath + ".";
                log.error((Object)msg);
                throw new RegistryException(msg, (Throwable)e);
            }
            String serviceName = CommonUtil.getServiceName(serviceInfoElement);
            String serviceNamespace = CommonUtil.getServiceNamespace(serviceInfoElement);
            String servicePath = "";
            if (serviceInfoElement.getChildrenWithLocalName("newServicePath").hasNext()) {
                Iterator OmElementIterator = serviceInfoElement.getChildrenWithLocalName("newServicePath");
                if (OmElementIterator.hasNext()) {
                    OMElement next = (OMElement)OmElementIterator.next();
                    servicePath = next.getText();
                }
            } else {
                servicePath = RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)(registry.getRegistryContext().getServicePath() + (serviceNamespace == null ? "" : CommonUtil.derivePathFragmentFromNamespace(serviceNamespace)) + serviceName));
            }
            String serviceVersion = org.wso2.carbon.registry.common.utils.CommonUtil.getServiceVersion((OMElement)serviceInfoElement);
            if (serviceVersion.length() == 0) {
                serviceVersion = this.defaultServiceVersion;
                CommonUtil.setServiceVersion(serviceInfoElement, serviceVersion);
                resource.setContent((Object)serviceInfoElement.toString());
            }
            if ((serviceId = resource.getUUID()) == null) {
                serviceId = UUID.randomUUID().toString();
                resource.setUUID(serviceId);
            }
            if (registry.resourceExists(servicePath)) {
                Resource oldResource = registry.get(servicePath);
                Object content = oldResource.getContent();
                String oldContent = content instanceof String ? (String)content : RegistryUtils.decodeBytes((byte[])((byte[])content));
                OMElement oldServiceInfoElement = null;
                if (serviceInfo.equals(oldContent)) {
                    String tempPath = "/_system/governance/" + resourceName;
                    if (!originalServicePath.equals(tempPath)) {
                        String path = RegistryUtils.getRelativePathToOriginal((String)servicePath, (String)"/_system/governance");
                        if (!ServiceUtils.getModifiedList().contains(path)) {
                            ServiceUtils.addToModifiedList(path);
                        }
                        return;
                    }
                    requestContext.setProcessingComplete(true);
                    return;
                }
                if ("true".equals(resource.getProperty("registry.WSDLImport"))) {
                    resource.removeProperty("registry.WSDLImport");
                    try {
                        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(oldContent));
                        StAXOMBuilder builder = new StAXOMBuilder(reader);
                        oldServiceInfoElement = builder.getDocumentElement();
                        CommonUtil.setServiceName(oldServiceInfoElement, CommonUtil.getServiceName(serviceInfoElement));
                        CommonUtil.setServiceNamespace(oldServiceInfoElement, CommonUtil.getServiceNamespace(serviceInfoElement));
                        CommonUtil.setWSDLURL(oldServiceInfoElement, CommonUtil.getWSDLURL(serviceInfoElement));
                        CommonUtil.setEndpointEntries(oldServiceInfoElement, CommonUtil.getEndpointEntries(serviceInfoElement));
                        CommonUtil.setServiceVersion(oldServiceInfoElement, org.wso2.carbon.registry.common.utils.CommonUtil.getServiceVersion((OMElement)serviceInfoElement));
                        serviceInfoElement = oldServiceInfoElement;
                        resource.setContent((Object)serviceInfoElement.toString());
                    }
                    catch (Exception e) {
                        String msg = "Error in parsing the service content of the service. The requested path to store the service: " + originalServicePath + ".";
                        log.error((Object)msg);
                        throw new RegistryException(msg, (Throwable)e);
                    }
                }
                try {
                    previousServiceInfoElement = AXIOMUtil.stringToOM((String)oldContent);
                }
                catch (XMLStreamException e) {
                    String msg = "Error in parsing the service content of the service. The requested path to store the service: " + originalServicePath + ".";
                    log.error((Object)msg);
                    throw new RegistryException(msg, (Throwable)e);
                }
            }
            boolean alreadyAdded = false;
            String wsdlURL = CommonUtil.getWSDLURL(serviceInfoElement);
            if (wsdlURL != null && (wsdlURL.startsWith("http://") || wsdlURL.startsWith("https://"))) {
                wsdl = this.buildWSDLProcessor(requestContext);
                RequestContext context = new RequestContext(registry, requestContext.getRepository(), requestContext.getVersionRepository());
                context.setResourcePath(new ResourcePath("/" + serviceName + ".wsdl"));
                context.setSourceURL(wsdlURL);
                context.setResource((Resource)new ResourceImpl());
                String wsdlPath = wsdl.addWSDLToRegistry(context, wsdlURL, null, false, false, this.disableWSDLValidation);
                if (wsdlPath == null) {
                    return;
                }
                wsdlURL = RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)wsdlPath);
                CommonUtil.setWSDLURL(serviceInfoElement, wsdlURL);
                resource.setContent((Object)RegistryUtils.decodeBytes((byte[])serviceInfoElement.toString().getBytes()));
                ((ResourceImpl)resource).prepareContentForPut();
                this.persistServiceResource(registry, resource, servicePath);
                alreadyAdded = true;
                registry.addAssociation(servicePath, wsdlPath, "depends");
                registry.addAssociation(wsdlPath, servicePath, "usedBy");
            } else if (wsdlURL != null && wsdlURL.startsWith("/")) {
                String wsdlPath = RegistryUtils.getAbsolutePath((RegistryContext)requestContext.getRegistryContext(), (String)wsdlURL);
                if (!wsdlPath.startsWith(RegistryUtils.getAbsolutePath((RegistryContext)requestContext.getRegistryContext(), (String)"/_system/governance"))) {
                    wsdlPath = "/_system/governance" + wsdlPath;
                }
                boolean addItHere = false;
                if (!registry.resourceExists(wsdlPath)) {
                    String msg = "Associating service to a non-existing WSDL. wsdl url: " + wsdlPath + ", " + "service path: " + servicePath + ".";
                    log.error((Object)msg);
                    throw new RegistryException(msg);
                }
                if (!registry.resourceExists(servicePath)) {
                    addItHere = true;
                } else {
                    Association[] dependencies = registry.getAssociations(servicePath, "depends");
                    boolean dependencyFound = false;
                    if (dependencies != null) {
                        for (Association dependency : dependencies) {
                            if (!wsdlPath.equals(dependency.getDestinationPath())) continue;
                            dependencyFound = true;
                        }
                    }
                    if (!dependencyFound) {
                        addItHere = true;
                    }
                }
                if (addItHere) {
                    ((ResourceImpl)resource).prepareContentForPut();
                    this.persistServiceResource(registry, resource, servicePath);
                    alreadyAdded = true;
                    registry.addAssociation(servicePath, wsdlPath, "depends");
                    registry.addAssociation(wsdlPath, servicePath, "usedBy");
                }
            }
            if (!alreadyAdded) {
                ((ResourceImpl)resource).prepareContentForPut();
                this.persistServiceResource(registry, resource, servicePath);
            }
            if (previousServiceInfoElement != null) {
                EndpointUtils.removeObsoleteWsdlEndpoint(previousServiceInfoElement, serviceInfoElement, servicePath, registry);
            }
            if (servicePath.contains(registry.getRegistryContext().getServicePath())) {
                EndpointUtils.saveEndpointsFromServices(servicePath, serviceInfoElement, registry, CommonUtil.getUnchrootedSystemRegistry(requestContext));
            }
            String symlinkLocation = RegistryUtils.getAbsolutePath((RegistryContext)requestContext.getRegistryContext(), (String)requestContext.getResource().getProperty("SymlinkPropertyName"));
            if (!servicePath.equals(originalServicePath)) {
                Resource serviceResource = requestContext.getRegistry().get(RegistryUtils.getParentPath((String)originalServicePath));
                String isLink = serviceResource.getProperty("registry.link");
                String mountPoint = serviceResource.getProperty("registry.mountpoint");
                String targetPoint = serviceResource.getProperty("registry.targetpoint");
                String actualPath = serviceResource.getProperty("registry.actualpath");
                if (isLink != null && mountPoint != null && targetPoint != null) {
                    symlinkLocation = actualPath + "/";
                }
                if (symlinkLocation != null) {
                    requestContext.getSystemRegistry().createLink(symlinkLocation + resourceName, servicePath);
                }
            }
            requestContext.setProcessingComplete(true);
            if (wsdl != null && "enable".equals(System.getProperty("uddi"))) {
                BusinessServiceInfo businessServiceInfo = new BusinessServiceInfo();
                businessServiceInfo.setServiceName(serviceName.trim());
                businessServiceInfo.setServiceNamespace(serviceNamespace.trim());
                businessServiceInfo.setServiceDescription(CommonUtil.getServiceDescription(serviceInfoElement));
                WSDLInfo wsdlInfo = wsdl.getMasterWSDLInfo();
                businessServiceInfo.setServiceWSDLInfo(wsdlInfo);
                businessServiceInfo.setServiceEndpoints(CommonUtil.getEndpointEntries(serviceInfoElement));
                businessServiceInfo.setDocuments(CommonUtil.getDocLinks(serviceInfoElement));
                UDDIPublisher publisher = new UDDIPublisher(businessServiceInfo);
                publisher.publishBusinessService();
            }
            String path = RegistryUtils.getRelativePathToOriginal((String)servicePath, (String)"/_system/governance");
            ServiceUtils.addToModifiedList(path);
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }

    protected WSDLProcessor buildWSDLProcessor(RequestContext requestContext) {
        return new WSDLProcessor(requestContext);
    }

    private void persistServiceResource(Registry registry, Resource resource, String servicePath) throws RegistryException {
        registry.put(servicePath, resource);
    }

    public void setDisableWSDLValidation(String disableWSDLValidation) {
        this.disableWSDLValidation = Boolean.toString(true).equals(disableWSDLValidation);
    }

    public String mergeServiceContent(String newContent, String oldContent) {
        return newContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        try {
            Registry registry = requestContext.getRegistry();
            ResourcePath resourcePath = requestContext.getResourcePath();
            if (resourcePath == null) {
                throw new RegistryException("The resource path is not available.");
            }
            Resource resource = registry.get(resourcePath.getPath());
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }
}

