/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.SimpleTimeZone;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class ProjectMediaTypeHandler
extends Handler {
    private String mediaType = "application/vnd.wso2-project+xml";
    private String location;

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        try {
            Resource resource = requestContext.getResource();
            Object content = resource.getContent();
            String payload = content instanceof String ? (String)content : RegistryUtils.decodeBytes((byte[])((byte[])content));
            try {
                this.populateProjectProperties(AXIOMUtil.stringToOM((String)payload), resource);
                String path = this.location + RegistryUtils.getResourceName((String)requestContext.getResourcePath().getPath());
                requestContext.getRegistry().put("/_system/governance" + path, resource);
                requestContext.setProcessingComplete(true);
            }
            catch (ParseException e) {
                throw new RegistryException("Unable to parse project configuration", (Throwable)e);
            }
            catch (XMLStreamException e) {
                throw new RegistryException("Unable to parse project configuration", (Throwable)e);
            }
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importResource(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        try {
            InputStream inputStream;
            Resource resource;
            if (requestContext.getResource() == null) {
                resource = new ResourceImpl();
                resource.setMediaType(this.mediaType);
            } else {
                resource = requestContext.getResource();
            }
            String sourceURL = requestContext.getSourceURL();
            try {
                if (sourceURL != null && sourceURL.toLowerCase().startsWith("file:")) {
                    String msg = "The source URL must not be file in the server's local file system";
                    throw new RegistryException(msg);
                }
                inputStream = new URL(sourceURL).openStream();
            }
            catch (IOException e) {
                throw new RegistryException("The URL " + sourceURL + " is incorrect.", (Throwable)e);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                int nextChar;
                while ((nextChar = inputStream.read()) != -1) {
                    outputStream.write(nextChar);
                }
                outputStream.flush();
            }
            catch (IOException e) {
                throw new RegistryException("Error while reading project definition", (Throwable)e);
            }
            byte[] bytes = outputStream.toByteArray();
            resource.setContent((Object)bytes);
            try {
                this.populateProjectProperties(AXIOMUtil.stringToOM((String)RegistryUtils.decodeBytes((byte[])bytes)), resource);
            }
            catch (ParseException e) {
                throw new RegistryException("Unable to parse project configuration", (Throwable)e);
            }
            catch (XMLStreamException e) {
                throw new RegistryException("Unable to parse project configuration", (Throwable)e);
            }
            String path = this.location + RegistryUtils.getResourceName((String)requestContext.getResourcePath().getPath());
            requestContext.getRegistry().put("/_system/governance" + path, resource);
            requestContext.setProcessingComplete(true);
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }

    private void populateProjectProperties(OMElement payload, Resource projectResource) throws ParseException {
        OMElement finishDateElement;
        String MS_PROJECT_NS = payload.getNamespace().getNamespaceURI();
        SimpleDateFormat PROJECT_TIME_FORMAT = new SimpleDateFormat("'PT'H'H'm'M's'S'");
        PROJECT_TIME_FORMAT.setTimeZone(new SimpleTimeZone(0, "UTC"));
        String startDate = null;
        String finishDate = null;
        long duration = 0L;
        float cost = 0.0f;
        float remainingCost = 0.0f;
        OMElement startDateElement = payload.getFirstChildWithName(new QName(MS_PROJECT_NS, "StartDate"));
        if (startDateElement != null) {
            startDate = startDateElement.getText();
        }
        if ((finishDateElement = payload.getFirstChildWithName(new QName(MS_PROJECT_NS, "FinishDate"))) != null) {
            finishDate = finishDateElement.getText();
        }
        LinkedHashMap<Integer, Float> rates = new LinkedHashMap<Integer, Float>();
        OMElement resourcesElement = payload.getFirstChildWithName(new QName(MS_PROJECT_NS, "Resources"));
        if (resourcesElement != null) {
            Iterator resourceElements = resourcesElement.getChildrenWithName(new QName(MS_PROJECT_NS, "Resource"));
            while (resourceElements.hasNext()) {
                OMElement resourceElement = (OMElement)resourceElements.next();
                OMElement idElement = resourceElement.getFirstChildWithName(new QName(MS_PROJECT_NS, "ID"));
                OMElement standardRateElement = resourceElement.getFirstChildWithName(new QName(MS_PROJECT_NS, "StandardRate"));
                rates.put(Integer.parseInt(idElement.getText()), Float.valueOf(Float.parseFloat(standardRateElement.getText())));
            }
        }
        OMElement assignmentsElement = payload.getFirstChildWithName(new QName(MS_PROJECT_NS, "Assignments"));
        long work = 0L;
        long remainingWork = 0L;
        if (assignmentsElement != null) {
            Iterator assignmentElements = assignmentsElement.getChildrenWithName(new QName(MS_PROJECT_NS, "Assignment"));
            while (assignmentElements.hasNext()) {
                OMElement assignmentElement = (OMElement)assignmentElements.next();
                OMElement resourceElement = assignmentElement.getFirstChildWithName(new QName(MS_PROJECT_NS, "ResourceUID"));
                if (Long.parseLong(resourceElement.getText()) < 0L) continue;
                OMElement workElement = assignmentElement.getFirstChildWithName(new QName(MS_PROJECT_NS, "Work"));
                long time = PROJECT_TIME_FORMAT.parse(workElement.getText()).getTime();
                work += time;
                cost += (float)time / 1000.0f / 60.0f / 60.0f * ((Float)rates.get(Integer.parseInt(resourceElement.getText()))).floatValue();
                OMElement remainingWorkElement = assignmentElement.getFirstChildWithName(new QName(MS_PROJECT_NS, "RemainingWork"));
                time = PROJECT_TIME_FORMAT.parse(remainingWorkElement.getText()).getTime();
                remainingWork += time;
                remainingCost += (float)time / 1000.0f / 60.0f / 60.0f * ((Float)rates.get(Integer.parseInt(resourceElement.getText()))).floatValue();
            }
        }
        long total = work / 1000L / 60L / 60L;
        long remaining = remainingWork / 1000L / 60L / 60L;
        OMElement tasksElement = payload.getFirstChildWithName(new QName(MS_PROJECT_NS, "Tasks"));
        if (tasksElement != null) {
            Iterator taskElements = tasksElement.getChildrenWithName(new QName(MS_PROJECT_NS, "Task"));
            while (taskElements.hasNext()) {
                OMElement taskElement = (OMElement)taskElements.next();
                OMElement typeElement = taskElement.getFirstChildWithName(new QName(MS_PROJECT_NS, "Type"));
                if (Integer.parseInt(typeElement.getText()) < 0) continue;
                OMElement durationElement = taskElement.getFirstChildWithName(new QName(MS_PROJECT_NS, "Duration"));
                duration += PROJECT_TIME_FORMAT.parse(durationElement.getText()).getTime() / 1000L / 60L / 60L / 8L;
            }
        }
        if (startDate != null) {
            projectResource.setProperty("Start Date", startDate);
        }
        if (finishDate != null) {
            projectResource.setProperty("Finish Date", finishDate);
        }
        if (duration > 0L) {
            projectResource.setProperty("Duration", duration + " days");
        }
        if (total > 0L) {
            projectResource.setProperty("Scheduled Work", total + " hours");
        }
        if (remaining > 0L) {
            projectResource.setProperty("Remaining Work", remaining + " hours");
        }
        if (total - remaining > 0L) {
            projectResource.setProperty("Actual Work", total - remaining + " hours");
        }
        if (cost > 0.0f) {
            projectResource.setProperty("Scheduled Cost", "$" + String.format("%.2f", new Float(cost)));
        }
        if (remainingCost > 0.0f) {
            projectResource.setProperty("Remaining Cost", "$" + String.format("%.2f", new Float(remainingCost)));
        }
        if (cost - remainingCost > 0.0f) {
            projectResource.setProperty("Actual Cost", "$" + String.format("%.2f", new Float(cost - remainingCost)));
        }
    }
}

