/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.AuthorizationUtils;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class PolicyMediaTypeHandler
extends Handler {
    private static final Log log = LogFactory.getLog(PolicyMediaTypeHandler.class);
    private String location = "/policies/";
    private String locationTag = "location";
    private OMElement locationConfiguration;

    public OMElement getPolicyLocationConfiguration() {
        return this.locationConfiguration;
    }

    public void setPolicyLocationConfiguration(OMElement locationConfiguration) throws RegistryException {
        Iterator confElements = locationConfiguration.getChildElements();
        while (confElements.hasNext()) {
            OMElement confElement = (OMElement)confElements.next();
            if (!confElement.getQName().equals(new QName(this.locationTag))) continue;
            this.location = confElement.getText();
            if (!this.location.startsWith("/")) {
                this.location = "/" + this.location;
            }
            if (this.location.endsWith("/")) continue;
            this.location = this.location + "/";
        }
        AuthorizationUtils.addAuthorizeRoleListener((int)101, (String)this.getChrootedLocation(RegistryContext.getBaseInstance()), (String)"/permission/admin/manage/resources/govern/metadata/add", (String)"ui.execute");
        AuthorizationUtils.addAuthorizeRoleListener((int)111, (String)this.getChrootedLocation(RegistryContext.getBaseInstance()), (String)"/permission/admin/manage/resources/govern/metadata/list", (String)"ui.execute", (String[])new String[]{"http://www.wso2.org/projects/registry/actions/get"});
        this.locationConfiguration = locationConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        try {
            if (requestContext == null) {
                throw new RegistryException("The request context is not available.");
            }
            String path = requestContext.getResourcePath().getPath();
            Resource resource = requestContext.getResource();
            Registry registry = requestContext.getRegistry();
            Object newContent = resource.getContent();
            if (newContent instanceof String) {
                newContent = RegistryUtils.encodeString((String)((String)newContent));
            }
            try {
                if (registry.resourceExists(path)) {
                    Resource oldResource = registry.get(path);
                    Object oldContent = oldResource.getContent();
                    if (newContent == null && oldContent == null || newContent != null && newContent.equals(oldContent)) {
                        return;
                    }
                }
            }
            catch (Exception e) {
                String msg = "Error in comparing the policy content updates. policy path: " + path + ".";
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, (Throwable)e);
            }
            if (newContent != null) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream((byte[])newContent);
                this.addPolicyToRegistry(requestContext, inputStream);
            }
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importResource(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        try {
            InputStream inputStream;
            String sourceURL = requestContext.getSourceURL();
            try {
                if (sourceURL != null && sourceURL.toLowerCase().startsWith("file:")) {
                    String msg = "The source URL must not be file in the server's local file system";
                    throw new RegistryException(msg);
                }
                inputStream = new URL(sourceURL).openStream();
            }
            catch (IOException e) {
                throw new RegistryException("The URL " + sourceURL + " is incorrect.", (Throwable)e);
            }
            this.addPolicyToRegistry(requestContext, inputStream);
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }

    private void addPolicyToRegistry(RequestContext requestContext, InputStream inputStream) throws RegistryException {
        Resource policyResource;
        if (requestContext.getResource() == null) {
            policyResource = new ResourceImpl();
            policyResource.setMediaType("application/policy+xml");
        } else {
            policyResource = requestContext.getResource();
        }
        Registry registry = requestContext.getRegistry();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int nextChar;
            while ((nextChar = inputStream.read()) != -1) {
                outputStream.write(nextChar);
            }
            outputStream.flush();
        }
        catch (IOException e) {
            throw new RegistryException("Exception occured while reading policy content", (Throwable)e);
        }
        policyResource.setContent((Object)outputStream.toByteArray());
        try {
            AXIOMUtil.stringToOM((String)RegistryUtils.decodeBytes((byte[])outputStream.toByteArray()));
        }
        catch (Exception e) {
            throw new RegistryException("The given policy file does not contain valid XML.");
        }
        String resourcePath = requestContext.getResourcePath().getPath();
        String policyFileName = resourcePath.substring(resourcePath.lastIndexOf("/") + 1);
        Registry systemRegistry = CommonUtil.getUnchrootedSystemRegistry(requestContext);
        String commonLocation = this.getChrootedLocation(requestContext.getRegistryContext());
        if (!systemRegistry.resourceExists(commonLocation)) {
            systemRegistry.put(commonLocation, (Resource)systemRegistry.newCollection());
        }
        String policyPath = !resourcePath.startsWith(commonLocation) && !resourcePath.equals("/" + policyFileName) && !resourcePath.equals("/_system/governance/" + policyFileName) ? resourcePath : commonLocation + this.extractResourceFromURL(policyFileName, ".xml");
        String policyId = policyResource.getUUID();
        if (policyId == null) {
            policyId = UUID.randomUUID().toString();
            policyResource.setUUID(policyId);
        }
        String relativeArtifactPath = RegistryUtils.getRelativePath((RegistryContext)registry.getRegistryContext(), (String)policyPath);
        relativeArtifactPath = RegistryUtils.getRelativePathToOriginal((String)relativeArtifactPath, (String)"/_system/governance");
        this.addPolicyToRegistry(requestContext, policyPath, requestContext.getSourceURL(), policyResource, registry);
        ((ResourceImpl)policyResource).setPath(relativeArtifactPath);
        String symlinkLocation = RegistryUtils.getAbsolutePath((RegistryContext)requestContext.getRegistryContext(), (String)policyResource.getProperty("SymlinkPropertyName"));
        if (symlinkLocation != null) {
            Resource resource = requestContext.getRegistry().get(symlinkLocation);
            if (resource != null) {
                String isLink = resource.getProperty("registry.link");
                String mountPoint = resource.getProperty("registry.mountpoint");
                String targetPoint = resource.getProperty("registry.targetpoint");
                String actualPath = resource.getProperty("registry.actualpath");
                if (isLink != null && mountPoint != null && targetPoint != null) {
                    symlinkLocation = actualPath + "/";
                }
            }
            requestContext.getSystemRegistry().createLink(symlinkLocation + policyFileName, policyPath);
        }
        requestContext.setProcessingComplete(true);
    }

    protected void addPolicyToRegistry(RequestContext context, String path, String url, Resource resource, Registry registry) throws RegistryException {
        context.setActualPath(path);
        registry.put(path, resource);
    }

    private String extractResourceFromURL(String policyURL, String suffix) {
        String resourceName = policyURL;
        if (policyURL.lastIndexOf("?") > 0) {
            resourceName = policyURL.substring(0, policyURL.indexOf("?")) + suffix;
        } else if (policyURL.indexOf(".") > 0) {
            resourceName = policyURL.substring(0, policyURL.lastIndexOf(".")) + suffix;
        } else if (!policyURL.endsWith(suffix)) {
            resourceName = policyURL + suffix;
        }
        return resourceName;
    }

    private String getChrootedLocation(RegistryContext registryContext) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)("/_system/governance" + this.location));
    }
}

