/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class EncryptionHandler
extends Handler {
    private static final Log log = LogFactory.getLog(EncryptionHandler.class);
    private String[] propertyNames = new String[0];
    private boolean encryptContent = false;
    private boolean allProperties = false;

    public void setPropertyNames(String propertyNames) {
        this.allProperties = propertyNames.equals("all");
        if (!this.allProperties) {
            this.propertyNames = propertyNames.split(",");
            for (int i = 0; i < this.propertyNames.length; ++i) {
                this.propertyNames[i] = this.propertyNames[i].trim();
            }
        }
    }

    public void setEncryptContent(boolean encryptContent) {
        this.encryptContent = encryptContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource get(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return null;
        }
        CommonUtil.acquireUpdateLock();
        try {
            Resource resource = requestContext.getRegistry().get(requestContext.getResourcePath().getPath());
            if (resource != null) {
                if (this.allProperties) {
                    Properties props = resource.getProperties();
                    for (Object key : props.keySet()) {
                        String propKey = (String)key;
                        this.decodeProperty(resource, propKey);
                    }
                } else {
                    for (String propKey : this.propertyNames) {
                        this.decodeProperty(resource, propKey);
                    }
                }
                if (this.encryptContent) {
                    try {
                        Object content = resource.getContent();
                        if (content != null) {
                            if (content instanceof String) {
                                resource.setContent((Object)new String(CryptoUtil.getDefaultCryptoUtil().base64DecodeAndDecrypt((String)content)));
                            } else if (content instanceof byte[]) {
                                resource.setContent((Object)CryptoUtil.getDefaultCryptoUtil().decrypt((byte[])content));
                            } else {
                                log.warn((Object)("Unable to decrypt unknown content type for resource path: " + resource.getPath()));
                            }
                        }
                    }
                    catch (CryptoException e) {
                        log.error((Object)("Unable to decrypt content for resource path: " + resource.getPath()), (Throwable)e);
                    }
                }
            }
            requestContext.setProcessingComplete(true);
            Resource resource2 = resource;
            return resource2;
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }

    public void put(RequestContext requestContext) throws RegistryException {
        Resource resource = requestContext.getResource();
        if (resource != null) {
            if (this.allProperties) {
                Properties props = resource.getProperties();
                for (Object key : props.keySet()) {
                    String propKey = (String)key;
                    this.encodeProperty(resource, propKey);
                }
            } else {
                for (String propKey : this.propertyNames) {
                    this.encodeProperty(resource, propKey);
                }
            }
            if (this.encryptContent) {
                try {
                    Object content = resource.getContent();
                    if (content != null) {
                        if (content instanceof String) {
                            resource.setContent((Object)CryptoUtil.getDefaultCryptoUtil().encryptAndBase64Encode(((String)content).getBytes()));
                        } else if (content instanceof byte[]) {
                            resource.setContent((Object)CryptoUtil.getDefaultCryptoUtil().encrypt((byte[])content));
                        } else {
                            log.warn((Object)("Unable to encrypt unknown content type for resource path: " + resource.getPath()));
                        }
                    }
                }
                catch (CryptoException e) {
                    log.error((Object)("Unable to encrypt content for resource path: " + resource.getPath()), (Throwable)e);
                }
            }
        }
    }

    private void encodeProperty(Resource resource, String propKey) {
        try {
            resource.setProperty(propKey, CryptoUtil.getDefaultCryptoUtil().encryptAndBase64Encode(resource.getProperty(propKey).getBytes()));
        }
        catch (CryptoException e) {
            log.error((Object)("Unable to encrypt property key: " + propKey + " for resource " + "path: " + resource.getPath()), (Throwable)e);
        }
    }

    private void decodeProperty(Resource resource, String propKey) {
        try {
            resource.setProperty(propKey, new String(CryptoUtil.getDefaultCryptoUtil().base64DecodeAndDecrypt(resource.getProperty(propKey))));
        }
        catch (CryptoException e) {
            log.error((Object)("Unable to decrypt property key: " + propKey + " for resource " + "path: " + resource.getPath()), (Throwable)e);
        }
    }
}

