/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;

public class DeleteServiceHandler
extends Handler {
    private static ThreadLocal<Boolean> deleteInProgress = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(RequestContext requestContext) throws RegistryException {
        if (!DeleteServiceHandler.isDeleteLockAvailable()) {
            return;
        }
        DeleteServiceHandler.acquireDeleteLock();
        try {
            Registry registry = requestContext.getRegistry();
            String parentPath = requestContext.getResource().getParentPath();
            registry.delete(requestContext.getResource().getPath());
            this.deleteRecursively(parentPath, registry);
            requestContext.setProcessingComplete(true);
        }
        finally {
            DeleteServiceHandler.releaseDeleteLock();
        }
    }

    private void deleteRecursively(String path, Registry registry) throws RegistryException {
        Resource currentResource = registry.get(path);
        if (currentResource instanceof Collection && ((Collection)currentResource).getChildCount() == 0) {
            registry.delete(path);
            this.deleteRecursively(currentResource.getParentPath(), registry);
        }
    }

    public static boolean isDeleteLockAvailable() {
        return deleteInProgress.get() == false;
    }

    public static void acquireDeleteLock() {
        deleteInProgress.set(true);
    }

    public static void releaseDeleteLock() {
        deleteInProgress.set(false);
    }
}

