/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.aspects;

import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.extensions.aspects.Lifecycle;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

public class ReviewLifecycle
extends Lifecycle {
    public static final String REVIEWER = "reviewer";
    protected final String ORIGINAL_PATH = "registry.originalPath";

    @Override
    public void associate(Resource resource, Registry registry) throws RegistryException {
        String path;
        String reviewer = resource.getProperty(REVIEWER);
        if (reviewer == null) {
            throw new RegistryException("No reviewer property");
        }
        try {
            UserRealm userRealm = CurrentSession.getUserRealm();
            if (!userRealm.getUserStoreManager().isExistingUser(reviewer)) {
                throw new RegistryException("No such user '" + reviewer + "'");
            }
        }
        catch (UserStoreException e) {
            throw new RegistryException("User Store Exception", (Throwable)e);
        }
        String name = path = resource.getPath();
        int idx = name.lastIndexOf("/");
        name = name.substring(idx + 1, name.length());
        if (name.length() == 0) {
            throw new RegistryException("Can't associate Review to root resource");
        }
        String newPath = "/people/" + reviewer + "/to-review/" + name;
        registry.copy(path, newPath);
        Resource r = registry.get(newPath);
        registry.addAssociation(newPath, path, "original");
        r.setProperty("registry.Aspects", "Review");
        registry.put(newPath, r);
    }

    @Override
    public void invoke(RequestContext context, String action) throws RegistryException {
        String value;
        if ("approve".equals(action)) {
            value = "approved";
        } else if ("reject".equals(action)) {
            value = "rejected";
        } else {
            throw new RegistryException("Not a valid action");
        }
        Registry registry = context.getRegistry();
        Association[] associations = registry.getAssociations(context.getResourcePath().getPath(), "original");
        if (associations == null) {
            throw new RegistryException("No original resource to approve");
        }
        Resource resource = context.getRepository().get(associations[0].getDestinationPath());
        resource.setProperty("approval", value);
        context.getRepository().put(resource.getPath(), resource);
    }

    @Override
    public String[] getAvailableActions(RequestContext context) {
        String reviewer = context.getResource().getProperty(REVIEWER);
        if (CurrentSession.getUser().equals(reviewer)) {
            return new String[]{"approve", "reject"};
        }
        return new String[0];
    }
}

