/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.util;

import java.util.ResourceBundle;

public class MessageList {
    private ResourceBundle messageResourceBundle = null;

    public MessageList(String resourceBundleName) {
        this.messageResourceBundle = ResourceBundle.getBundle(resourceBundleName);
    }

    public String getMessage(String key, String defaultMessage) {
        return this.getMessage(key, null, defaultMessage);
    }

    public String getMessage(String key, String messageData, String defaultMessage) {
        String message = defaultMessage;
        try {
            message = this.messageResourceBundle.getString(key);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (messageData != null) {
            message = message + " " + messageData;
        }
        return message;
    }

    public void printMessage(String key, String defaultMessage) {
        this.printMessage(key, null, defaultMessage);
    }

    public void printMessage(String key, String messageData, String defaultMessage) {
        System.out.println(this.getMessage(key, messageData, defaultMessage));
    }

    public static String getMessage(String resourceBundleName, String key, String messageData, String defaultMessage) {
        String message = defaultMessage;
        ResourceBundle messageResourceBundle = null;
        try {
            messageResourceBundle = ResourceBundle.getBundle(resourceBundleName);
            message = messageResourceBundle.getString(key);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (messageData != null) {
            message = message + " " + messageData;
        }
        if (!message.endsWith(".")) {
            message = message + ".";
        }
        return message;
    }

    public static void printMessage(String resourceBundleName, String key, String messageData, String defaultMessage) {
        System.out.println(MessageList.getMessage(resourceBundleName, key, messageData, defaultMessage));
    }
}

