/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.util;

public class BasicRules {
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final char SP = ' ';
    public static final char HT = '\t';
    public static final char DQ = '\"';
    public static final String CRLF = "\r\n";
    public static final char[] SEPARATORS = new char[]{'(', ')', '<', '>', '@', ',', ';', ':', '\\', '\"', '/', '[', ']', '?', '=', '{', '}', ' ', '\t'};

    public static boolean isOCTET(char ch) {
        return true;
    }

    public static boolean isCHAR(char ch) {
        return ch >= '\u0000' && ch <= '\u007f';
    }

    public static boolean isUPALPHA(char ch) {
        return ch >= 'A' && ch <= 'Z';
    }

    public static boolean isLOALPHA(char ch) {
        return ch >= 'a' && ch <= 'z';
    }

    public static boolean isALPHA(char ch) {
        return BasicRules.isLOALPHA(ch) || BasicRules.isUPALPHA(ch);
    }

    public static boolean isDIGIT(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isCTL(char ch) {
        return ch >= '\u0000' && ch <= '\u001f' || ch == '\u007f';
    }

    public static boolean isCR(char ch) {
        return ch == '\r';
    }

    public static boolean isLF(char ch) {
        return ch == '\n';
    }

    public static boolean isSP(char ch) {
        return ch == ' ';
    }

    public static boolean isHT(char ch) {
        return ch == '\t';
    }

    public static boolean isDoubleQuote(char ch) {
        return ch == '\"';
    }

    public static boolean isCRLF(String str) {
        return CRLF.equals(str);
    }

    public static boolean isLWS(String str) {
        int index = BasicRules.getLastIndexLWS(str, 0);
        return index != -1 && index == str.length();
    }

    public static int getLastIndexLWS(String str, int startIndex) {
        int index = str.indexOf(CRLF, startIndex);
        if (index == -1) {
            index = startIndex;
        } else if (index == startIndex) {
            index += CRLF.length();
        } else {
            return -1;
        }
        if (!BasicRules.isSP(str.charAt(index)) && BasicRules.isHT(str.charAt(index))) {
            return -1;
        }
        ++index;
        while (index < str.length()) {
            if (!BasicRules.isSP(str.charAt(index)) && BasicRules.isHT(str.charAt(index))) {
                return index;
            }
            ++index;
        }
        return index;
    }

    public static int getLastTEXT(String str, int startIndex) {
        int index;
        for (index = startIndex; index < str.length(); ++index) {
            if (!BasicRules.isOCTET(str.charAt(index))) {
                return index;
            }
            if (!BasicRules.isCTL(str.charAt(index))) continue;
            int lastLWS = BasicRules.getLastIndexLWS(str, index);
            if (lastLWS == -1) {
                return index;
            }
            index = lastLWS - 1;
        }
        return index;
    }

    public static boolean isHEX(char ch) {
        return ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f' || BasicRules.isDIGIT(ch);
    }

    public static boolean isToken(String str) {
        if (str.length() == 0) {
            return false;
        }
        for (int index = 0; index < str.length(); ++index) {
            char ch = str.charAt(index);
            if (BasicRules.isCHAR(ch) && !BasicRules.isSEPARATOR(ch) && !BasicRules.isCTL(ch)) continue;
            return false;
        }
        return true;
    }

    public static int getLastToken(String str, int startIndex) {
        int index;
        for (index = startIndex; index < str.length(); ++index) {
            char ch = str.charAt(index);
            if (BasicRules.isCHAR(ch) && !BasicRules.isSEPARATOR(ch) && !BasicRules.isCTL(ch)) continue;
            return index;
        }
        return index;
    }

    public static boolean isSEPARATOR(char ch) {
        for (int index = 0; index < SEPARATORS.length; ++index) {
            if (ch != SEPARATORS[index]) continue;
            return true;
        }
        return false;
    }

    public static int getLastComment(String str, int startIndex) {
        int index = startIndex;
        if (str.length() <= startIndex) {
            return startIndex;
        }
        if (str.charAt(index) != '(') {
            return startIndex;
        }
        boolean bExit = false;
        boolean bQuotedPair = false;
        int idx = startIndex + 1;
        while (!bExit) {
            while (!bQuotedPair) {
                if ((idx = BasicRules.getLastCtext(str, idx)) == str.length()) {
                    return idx;
                }
                if (!BasicRules.isQuotedPair(str, idx - 1)) {
                    bQuotedPair = true;
                    continue;
                }
                ++idx;
            }
            if (str.charAt(idx) == '(') {
                BasicRules.getLastComment(str, idx);
                continue;
            }
            if (str.charAt(idx) != ')') continue;
            return idx + 1;
        }
        return idx;
    }

    private static int getLastCtext(String str, int startIndex) {
        int iBracket;
        int idx = BasicRules.getLastTEXT(str, startIndex);
        for (iBracket = startIndex; iBracket < idx && str.charAt(iBracket) != '(' && str.charAt(iBracket) != ')'; ++iBracket) {
        }
        if (iBracket < idx) {
            idx = iBracket;
        }
        return idx;
    }

    private static int getLastQdtext(String str, int startIndex) {
        int iBracket;
        int idx = BasicRules.getLastTEXT(str, startIndex);
        for (iBracket = startIndex; iBracket < idx && str.charAt(iBracket) != '\"'; ++iBracket) {
        }
        if (iBracket < idx) {
            idx = iBracket;
        }
        return idx;
    }

    public static boolean isQuotedPair(String str, int startIndex) {
        return str.length() >= startIndex + 2 && str.charAt(startIndex) == '\\' && BasicRules.isCHAR(str.charAt(startIndex + 1));
    }

    public static int getLastQuotedString(String str, int startIndex) {
        int index;
        block5: {
            index = startIndex;
            if (startIndex == str.length()) {
                return startIndex;
            }
            if (str.charAt(index) != '\"') {
                return startIndex;
            }
            ++index;
            do {
                if ((index = BasicRules.getLastQdtext(str, index)) == str.length()) {
                    return startIndex;
                }
                if (!BasicRules.isQuotedPair(str, index - 1)) break block5;
            } while (++index != str.length());
            return startIndex;
        }
        if (str.charAt(index) != '\"') {
            return startIndex;
        }
        return ++index;
    }
}

