/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.ErrorList;
import org.eclipse.wst.wsi.internal.core.util.WSDLUtil;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;

public class BP2120
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();
    private Set wares = new HashSet();

    public BP2120(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public void visit(SOAPBinding binding, Object parent, WSDLTraversalContext ctx) {
        String style = binding.getStyle() == null ? "document" : binding.getStyle();
        ctx.addParameter("style", style);
    }

    public void visit(SOAPOperation operation, Object parent, WSDLTraversalContext ctx) {
        String style = operation.getStyle();
        if (style != null) {
            ctx.addParameter("style", style);
        }
    }

    public void visit(SOAPBody body, Object parent, WSDLTraversalContext ctx) {
        LinkedList<String> signature = new LinkedList<String>();
        String style = (String)ctx.getParameter("style");
        Operation op = ctx.getBindingOperation().getOperation();
        if (op == null || op.getInput() == null || op.getInput().getMessage() == null) {
            return;
        }
        Message m = op.getInput().getMessage();
        List parts = WSDLUtil.getParts(op, m, body, style);
        if (parts == null) {
            return;
        }
        signature.addAll(parts);
        if ("rpc".equals(style)) {
            signature.add(0, op.getName());
        }
        if (this.sameSignature(this.wares, signature)) {
            this.errors.add(op.getName());
        } else {
            this.wares.add(signature);
        }
    }

    private boolean sameSignature(Set signatureSet, List signature) {
        boolean same = false;
        Iterator set = signatureSet.iterator();
        while (set.hasNext() && !same) {
            List nextSignature = (List)set.next();
            if (nextSignature.size() != signature.size()) continue;
            Iterator iterator1 = nextSignature.iterator();
            Iterator iterator2 = signature.iterator();
            same = true;
            while (iterator1.hasNext() && iterator2.hasNext() && same) {
                Object element1 = iterator1.next();
                Object element2 = iterator2.next();
                if (element1 instanceof String && element2 instanceof String && ((String)element1).equals((String)element2)) {
                    same = true;
                    continue;
                }
                if (element1 instanceof Part && element2 instanceof Part) {
                    same = this.sameParts((Part)element1, (Part)element2);
                    continue;
                }
                same = false;
            }
        }
        return same;
    }

    private boolean sameParts(Part part1, Part part2) {
        boolean same = false;
        same = part1.getElementName() != null && part2.getElementName() != null && part1.getElementName().equals(part2.getElementName()) ? true : part1.getTypeName() != null && part2.getTypeName() != null && part1.getTypeName().equals(part2.getTypeName());
        return same;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        WSDLTraversal traversal = new WSDLTraversal();
        traversal.setVisitor(this);
        traversal.visitSOAPBinding(true);
        traversal.visitSOAPBody(true);
        traversal.visitSOAPOperation(true);
        traversal.ignoreBindingOutput();
        traversal.traverse((Binding)entryContext.getEntry().getEntryDetail());
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

