/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.uddi;

import java.util.Vector;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.uddi.UDDIValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.UDDIUtils;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.KeyedReference;

public class WSI3005_OBSOLETE
extends AssertionProcess {
    private final UDDIValidatorImpl validator;

    public WSI3005_OBSOLETE(UDDIValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        TModel tModel = (TModel)entryContext.getEntry().getEntryDetail();
        if (tModel == null) {
            this.result = "failed";
            this.failureDetailMessage = "Could not locate a tModel.";
        } else {
            CategoryBag bag = tModel.getCategoryBag();
            try {
                if (!this.checkCategoryBag(this.validator.uddiProxy, bag)) {
                    this.result = "failed";
                    this.failureDetailMessage = "The tModel key is: [" + tModel.getTModelKey() + "].";
                }
            }
            catch (IllegalStateException e) {
                this.result = "failed";
                this.failureDetailMessage = "The UDDI registry does not contain WSI conformance taxonomy tModel (\"ws-i-org:conformsTo:2002_12\").";
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetailMessage);
    }

    private boolean checkCategoryBag(UDDIProxy proxy, CategoryBag bag) {
        String conformanceKey = UDDIUtils.getWSIConformanceTModelKey(proxy);
        boolean result = false;
        if (bag != null) {
            Vector references = bag.getKeyedReferenceVector();
            for (int i = 0; i < references.size() && !result; ++i) {
                KeyedReference ref = (KeyedReference)references.get(i);
                result = ref.getTModelKey().equalsIgnoreCase(conformanceKey);
            }
        }
        return result;
    }
}

