/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.NullUtil;
import org.eclipse.wst.wsi.internal.core.util.OperationSignature;
import org.eclipse.wst.wsi.internal.core.util.TypesRegistry;
import org.eclipse.wst.wsi.internal.core.util.WSDLUtil;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSI1108
extends AssertionProcessVisitor
implements WSITag {
    private final BaseMessageValidator validator;
    private OperationSignature.OperationMatch match = null;
    private EntryContext entryContext = null;
    private OperationSignature responseSig = null;
    private Vector headerRarts = null;
    private boolean visitFault = false;
    private boolean existSOAPHeader = true;
    private boolean isRequest = false;
    private boolean existSOAPHeaderFault = true;

    public WSI1108(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public void visit(SOAPBody body, Object parent, WSDLTraversalContext ctx) {
        if (body.getRequired() != null && body.getRequired().booleanValue()) {
            return;
        }
        BindingOperation bop = ctx.getBindingOperation();
        if (bop.getOperation() == null || bop.getOperation().getOutput() == null || bop.getOperation().getOutput().getMessage() == null) {
            return;
        }
        Message msg = bop.getOperation().getOutput().getMessage();
        List parts = WSDLUtil.getParts(bop.getOperation(), msg, body, this.match.getOperationStyle());
        QName additionalName = null;
        if ("rpc".equals(this.match.getOperationStyle())) {
            String namespace = body.getNamespaceURI();
            if (namespace == null || namespace.length() == 0) {
                namespace = ctx.getBinding().getQName().getNamespaceURI();
            }
            additionalName = new QName(namespace, bop.getOperation().getOutput().getMessage().getQName().getLocalPart());
        }
        OperationSignature op = new OperationSignature(parts, null, new TypesRegistry(this.validator.analyzerContext.getCandidateInfo().getWsdlDocument().getDefinitions(), this.validator), false);
        if (additionalName != null) {
            op.getSignature().add(0, additionalName);
        }
        if (!((Object)op.getSignature()).equals(this.responseSig.getSignature())) {
            op = new OperationSignature(parts, null, new TypesRegistry(this.validator.analyzerContext.getCandidateInfo().getWsdlDocument().getDefinitions(), this.validator), true);
            if (additionalName != null) {
                op.getSignature().add(0, additionalName);
            }
            if (!((Object)op.getSignature()).equals(this.responseSig.getSignature())) {
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail("\nMessage:\n" + this.entryContext.getMessageEntry().getMessage(), this.entryContext);
                ctx.cancelBindingOperationProcessing();
            }
        }
    }

    public void visit(SOAPHeader header, Object parent, WSDLTraversalContext ctx) {
        if (!this.existSOAPHeaderFault) {
            this.existSOAPHeader = false;
            ctx.cancelBindingOperationProcessing();
            return;
        }
        if (header.getRequired() != null && header.getRequired().booleanValue()) {
            return;
        }
        Definition d = (Definition)ctx.getParameter("definition");
        TypesRegistry tReg = (TypesRegistry)ctx.getParameter("TypesRegistry");
        Part mesPart = WSDLUtil.getPart(d.getMessage(header.getMessage()), header.getPart());
        QName partQName = mesPart.getTypeName();
        if (partQName == null) {
            partQName = tReg.getType(mesPart.getElementName());
        }
        if (partQName == null) {
            throw new IllegalArgumentException("Part type can not be null." + mesPart.getElementName().toString());
        }
        String local = partQName.getLocalPart();
        String ns = partQName.getNamespaceURI();
        this.existSOAPHeader = false;
        for (int i = 0; i < this.headerRarts.size(); ++i) {
            Element elem = (Element)this.headerRarts.get(i);
            if (!elem.getLocalName().equals(local) || !NullUtil.equals(ns, elem.getNamespaceURI())) continue;
            this.existSOAPHeader = true;
            break;
        }
        if (this.existSOAPHeader) {
            ctx.cancelSOAPHeaderProcessing();
        }
        if (this.isRequest) {
            ctx.cancelBindingOperationProcessing();
        }
        if (!this.existSOAPHeader && !this.isRequest) {
            this.existSOAPHeaderFault = false;
        }
    }

    public void visit(SOAPHeaderFault headerFault, Object parent, WSDLTraversalContext ctx) {
        Definition d = (Definition)ctx.getParameter("definition");
        TypesRegistry tReg = (TypesRegistry)ctx.getParameter("TypesRegistry");
        Part mesPart = WSDLUtil.getPart(d.getMessage(headerFault.getMessage()), headerFault.getPart());
        QName partQName = mesPart.getTypeName();
        if (partQName == null) {
            partQName = tReg.getType(mesPart.getElementName());
        }
        if (partQName == null) {
            throw new IllegalArgumentException("Part type can not be null." + mesPart.getElementName().toString());
        }
        String local = partQName.getLocalPart();
        String ns = partQName.getNamespaceURI();
        for (int i = 0; i < this.headerRarts.size(); ++i) {
            Element elem = (Element)this.headerRarts.get(i);
            if (!elem.getLocalName().equals(local) || !NullUtil.equals(ns, elem.getNamespaceURI())) continue;
            this.existSOAPHeaderFault = true;
            break;
        }
        if (this.existSOAPHeaderFault) {
            ctx.cancelSOAPHeaderProcessing();
        }
    }

    public void visit(SOAPFault fault, Object parent, WSDLTraversalContext ctx) {
        this.visitFault = true;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        if (this.validator.isOneWayResponse(entryContext)) {
            this.result = "notApplicable";
        } else {
            this.entryContext = entryContext;
            Document doc = entryContext.getRequestDocument();
            this.match = OperationSignature.matchOperation(doc, null, this.validator.analyzerContext.getCandidateInfo().getBindings()[0], new TypesRegistry(this.validator.analyzerContext.getCandidateInfo().getWsdlDocument().getDefinitions(), this.validator), false);
            if (this.match != null) {
                this.isRequest = "request".equals(entryContext.getMessageEntry().getType());
                doc = entryContext.getMessageEntryDocument();
                if (!this.isRequest) {
                    this.responseSig = new OperationSignature(doc);
                    if ("rpc".equals(this.match.getOperationStyle())) {
                        this.responseSig.createRPCSignature();
                    }
                }
                Element headerElem = XMLUtils.findChildElement(doc.getDocumentElement(), WSITag.ELEM_SOAP_HEADER);
                this.headerRarts = new Vector();
                if (headerElem != null) {
                    this.headerRarts = XMLUtils.getChildElements(headerElem);
                }
                WSDLTraversal traversal = new WSDLTraversal();
                traversal.setVisitor(this);
                traversal.visitSOAPBody(true);
                traversal.visitSOAPHeader(true);
                traversal.visitSOAPHeaderFault(true);
                traversal.visitSOAPFault(true);
                traversal.ignoreReferences();
                traversal.ignoreBindingInput2SOAPBody();
                if (this.isRequest) {
                    traversal.ignoreBindingOutput();
                } else {
                    traversal.ignoreBindingInput2SOAPHeader();
                }
                if (this.responseSig != null && this.responseSig.isFault()) {
                    traversal.ignoreBindingOutput();
                } else {
                    traversal.ignoreBindingFault();
                }
                this.existSOAPHeaderFault = true;
                HashMap<String, Object> m = new HashMap<String, Object>();
                WSDLUtil.expandDefinition(this.validator.analyzerContext.getCandidateInfo().getWsdlDocument().getDefinitions());
                m.put("definition", this.validator.analyzerContext.getCandidateInfo().getWsdlDocument().getDefinitions());
                TypesRegistry tReg = new TypesRegistry(this.validator.analyzerContext.getCandidateInfo().getWsdlDocument().getDefinitions(), this.validator);
                m.put("TypesRegistry", tReg);
                traversal.traverse(this.match.getOperation(), m);
                if (!this.isRequest && this.existSOAPHeaderFault) {
                    this.existSOAPHeader = true;
                }
                if (this.responseSig != null && this.responseSig.isFault() && !this.visitFault) {
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail("\nMessage:\n" + entryContext.getMessageEntry().getMessage(), entryContext);
                }
                if (!this.existSOAPHeader) {
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail("\nMessage:\n" + entryContext.getMessageEntry().getMessage(), entryContext);
                }
            } else {
                this.result = "notApplicable";
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

